/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.damage;

import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.events.CustomHudChangeEvent;
import me.leothepro555.skills.events.SkillActiveStateChangeEvent;
import me.leothepro555.skills.events.SkillScalingTypeChangeEvent;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.VersionSupport;
import me.leothepro555.skilltype.EnergyType;
import me.leothepro555.skilltype.ScalingType;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class HealthAndEnergyManager
implements Listener {
    private Skills plugin;

    public HealthAndEnergyManager(final Skills plugin) {
        this.plugin = plugin;
        if (SkillsConfig.ConfigOption.IS_PERSISTENT_ACTIONBAR.getBoolean()) {
            Bukkit.getScheduler().runTaskTimer((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(p.getWorld().getName())) continue;
                        CustomHudChangeEvent event = new CustomHudChangeEvent(p);
                        Bukkit.getPluginManager().callEvent((Event)event);
                    }
                }
            }, 0L, 30L);
        }
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                for (final Player p : Bukkit.getOnlinePlayers()) {
                    PlayerInfo info;
                    if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(p.getWorld().getName()) || (info = plugin.getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p)).getSkill().getEnergyType() == EnergyType.HEALTH) continue;
                    double currEnergy = info.getActiveStatType(ScalingType.ENERGY);
                    double maxEnergy = info.getScalingType(ScalingType.ENERGY);
                    double energyRegen = info.getScalingType(ScalingType.ENERGY_REGEN);
                    if (info.getSkill().getEnergyType() == EnergyType.ENERGY || info.getSkill().getEnergyType() == EnergyType.MANA || info.getSkill().getEnergyType() == EnergyType.ARROWS) {
                        if (currEnergy + energyRegen >= maxEnergy) {
                            info.setActiveStatType(ScalingType.ENERGY, maxEnergy);
                        } else {
                            info.setActiveStatType(ScalingType.ENERGY, currEnergy + energyRegen);
                        }
                    } else if (info.getSkill().getEnergyType() == EnergyType.BLOOD) {
                        if (currEnergy - energyRegen <= 0.0) {
                            info.setActiveStatType(ScalingType.ENERGY, 0.0);
                        } else {
                            info.setActiveStatType(ScalingType.ENERGY, currEnergy - energyRegen);
                        }
                    } else if (info.getSkill().getEnergyType() == EnergyType.IMBALANCE) {
                        info.setActiveStatType(ScalingType.ENERGY, currEnergy + energyRegen);
                    }
                    if (currEnergy == info.getActiveStatType(ScalingType.ENERGY) || SkillsConfig.ConfigOption.IS_PERSISTENT_ACTIONBAR.getBoolean()) continue;
                    Bukkit.getScheduler().runTask((Plugin)plugin, new Runnable(){

                        @Override
                        public void run() {
                            CustomHudChangeEvent ev = new CustomHudChangeEvent(p);
                            Bukkit.getPluginManager().callEvent((Event)ev);
                        }
                    });
                }
            }
        }, 0L, 20L);
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (ExternalHandler.isCitizen(event.getEntity())) {
            return;
        }
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            Player p = (Player)event.getEntity();
            CustomHudChangeEvent chce = new CustomHudChangeEvent(p);
            Bukkit.getPluginManager().callEvent((Event)chce);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onScalingTypeUpdate(SkillScalingTypeChangeEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getPlayer().getWorld().getName())) {
            return;
        }
        this.updateStats(event.getPlayer());
    }

    @EventHandler
    public void onActiveAbilityChange(SkillActiveStateChangeEvent event) {
        CustomHudChangeEvent chce = new CustomHudChangeEvent(event.getPlayer());
        ExternalHandler.sendActionbarMessage(chce.getPlayer(), chce.getHud());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCustomHudChange(CustomHudChangeEvent chce) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(chce.getPlayer().getWorld().getName())) {
            return;
        }
        if (SkillsConfig.ConfigOption.USE_ACTIONBAR.getBoolean()) {
            ExternalHandler.sendActionbarMessage(chce.getPlayer(), chce.getHud());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRespawn(PlayerRespawnEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getPlayer().getWorld().getName())) {
            return;
        }
        this.setUpStats(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player p = event.getPlayer();
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getPlayer().getWorld().getName())) {
            p.setHealth(20.0);
            VersionSupport.setMaxHealth((LivingEntity)p, 20.0);
        } else {
            this.updateStats(p);
        }
    }

    public void setUpStats(Player p) {
        PlayerInfo info = this.plugin.getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        this.setUpStats(p, info);
    }

    public void setUpStats(Player p, PlayerInfo info) {
        VersionSupport.setMaxHealth((LivingEntity)p, info.getScalingType(ScalingType.HEALTH));
        p.setHealth(VersionSupport.getMaxHealth((LivingEntity)p));
        info.setActiveStatType(ScalingType.ENERGY, info.getSkill().getScaling(p, ScalingType.ENERGY));
    }

    public void updateStats(Player p) {
        PlayerInfo info = this.plugin.getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        this.updateStats(p, info);
    }

    public void updateStats(Player p, PlayerInfo info) {
        VersionSupport.setMaxHealth((LivingEntity)p, info.getScalingType(ScalingType.HEALTH));
    }
}

