/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.commands;

import me.leothepro555.skills.commands.SkillsCommand;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.skillsevents.EventManager;
import me.leothepro555.skills.skillsevents.SkillsEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class CommandStartXpBoost
extends SkillsCommand {
    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission("skills.startxpboost");
    }

    @Override
    public String getDescription() {
        return Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_StartXpBoost);
    }

    @Override
    public void runCommand(CommandSender sender, String[] args) {
        if (args.length == 3) {
            if (!EventManager.isEventOn(SkillsEvent.SkillsEventType.EXP)) {
                try {
                    int time = Integer.parseInt(args[1]);
                    double multiplier = Double.parseDouble(args[2]);
                    EventManager.startEvent(SkillsEvent.SkillsEventType.EXP, time * 60, multiplier);
                    Bukkit.broadcastMessage((String)Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_StartXpBoost_Broadcast).replaceAll("%multiplier%", String.valueOf(multiplier)).replaceAll("%time%", String.valueOf(time)));
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(ChatColor.RED + "Usage: /skill startxpboost [time in minutes] [multiplier]");
                }
            } else {
                sender.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_StartBoost_Already_Started).replaceAll("%time%", String.valueOf(EventManager.getTimeLeft(SkillsEvent.SkillsEventType.EXP) / 60)));
            }
        } else {
            sender.sendMessage(ChatColor.RED + "Usage: /skill startxpboost [time in minutes] [multiplier]");
        }
    }
}

