/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.commands;

import java.util.ArrayList;
import me.leothepro555.skills.commands.SkillsCommand;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.skillsevents.BonusType;
import me.leothepro555.skills.skillsevents.SkillsEvent;
import me.leothepro555.skills.stats.StatType;
import me.leothepro555.skills.utils.TimeUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class CommandSee
extends SkillsCommand {
    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission("skills.see");
    }

    @Override
    public String getDescription() {
        return Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_See);
    }

    @Override
    public void runCommand(CommandSender sender, String[] args) {
        if (args.length != 2) {
            sender.sendMessage(ChatColor.RED + "Usage: /skill see [player]");
            return;
        }
        if (Bukkit.getOfflinePlayer((String)args[1]) != null) {
            OfflinePlayer p = Bukkit.getOfflinePlayer((String)args[1]);
            Skills plugin = Skills.get();
            PlayerInfo info = plugin.getPlayerDataManager().getOrLoadPlayerInfo(p);
            sender.sendMessage(ChatColor.GOLD + "==========" + Skills.getLang().parseFirstString(info.getSkill().getLanguageName()) + "=========");
            ArrayList<BonusType> activeBonuses = info.getBonusList();
            if (activeBonuses.size() > 0) {
                for (BonusType type : activeBonuses) {
                    String time = TimeUtils.parseTimeSeconds(type.getTimeLeftInSeconds());
                    LanguageSupport.Languages lang = LanguageSupport.Languages.Command_Info_EXP_Bonus;
                    if (type.getType() == SkillsEvent.SkillsEventType.SOUL) {
                        lang = LanguageSupport.Languages.Command_Info_Soul_Bonus;
                    }
                    sender.sendMessage(String.valueOf(Skills.getLang().parseFirstString(lang)) + time);
                }
            }
            sender.sendMessage(String.valueOf(Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_Info_Souls)) + ChatColor.YELLOW + info.getSouls());
            sender.sendMessage(String.valueOf(Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_Info_Level)) + ChatColor.YELLOW + info.getLevel());
            sender.sendMessage(ChatColor.GOLD + "STR" + ChatColor.AQUA + " | " + ChatColor.LIGHT_PURPLE + "DEX" + ChatColor.AQUA + " | " + ChatColor.BLUE + "INT" + ChatColor.AQUA + " | " + ChatColor.RED + "DEF" + ChatColor.AQUA);
            sender.sendMessage(ChatColor.GOLD + info.getStat(StatType.STR) + ChatColor.AQUA + " | " + ChatColor.LIGHT_PURPLE + info.getStat(StatType.DEX) + ChatColor.AQUA + " | " + ChatColor.BLUE + info.getStat(StatType.INT) + ChatColor.AQUA + " | " + ChatColor.RED + info.getStat(StatType.DEF));
            sender.sendMessage(ChatColor.GOLD + "=========================");
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(ChatColor.RED);
            Skills.get();
            sender.sendMessage(stringBuilder.append(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Misc_Player_Doesnt_Exist)).toString());
        }
    }
}

