/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.commands;

import java.util.UUID;
import me.leothepro555.skills.commands.SkillsCommand;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.party.Party;
import me.leothepro555.skills.party.PartyManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandPartyShow
extends SkillsCommand {
    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission("skills.partyshow");
    }

    @Override
    public String getDescription() {
        return Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Partyshow);
    }

    @Override
    public void runCommand(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (!PartyManager.hasParty(p.getUniqueId())) {
                p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Party_Required));
                return;
            }
            Party party = PartyManager.getParty(p.getUniqueId());
            p.sendMessage(ChatColor.YELLOW + "====Party Stats====");
            for (UUID id : party.members.keySet()) {
                OfflinePlayer member = Bukkit.getOfflinePlayer((UUID)id);
                String status = "> " + member.getName();
                if (id.equals(party.getLeader())) {
                    status = String.valueOf(status) + " *";
                }
                status = member.isOnline() ? ChatColor.GREEN + status : ChatColor.RED + status;
                p.sendMessage(status);
                p.sendMessage(ChatColor.AQUA + Skills.getLang().parseFirstString(LanguageSupport.Languages.Party_Show_Bonus_Soul) + SkillsConfig.ConfigOption.PARTY_SOULS_PER_PLAYER.getString());
                p.sendMessage(ChatColor.AQUA + Skills.getLang().parseFirstString(LanguageSupport.Languages.Party_Show_Bonus_Xp_Rate) + SkillsConfig.ConfigOption.PARTY_EXP_PER_PLAYER.getString());
            }
        }
    }
}

