/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.commands;

import me.leothepro555.skills.commands.SkillsCommand;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.party.PartyManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandPartyInvite
extends SkillsCommand {
    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission("skills.partyinvite");
    }

    @Override
    public String getDescription() {
        return Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Partyinvite);
    }

    @Override
    public void runCommand(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            if (args.length == 2) {
                if (Bukkit.getPlayer((String)args[1]) != null) {
                    if (!PartyManager.hasParty(((Player)sender).getUniqueId())) {
                        sender.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Party_Required));
                        return;
                    }
                    Player invited = Bukkit.getPlayer((String)args[1]);
                    if (PartyManager.hasParty(invited.getUniqueId())) {
                        sender.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Party_Invited_Is_In_Party));
                        return;
                    }
                    sender.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Party_Invite_Success).replaceAll("%player%", invited.getName()));
                    PartyManager.invitePlayerToParty(invited, PartyManager.getParty(((Player)sender).getUniqueId()));
                    invited.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Party_Invite_Message).replaceAll("%player%", ((Player)sender).getName()));
                } else {
                    sender.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Party_Player_Invited_Offline));
                }
            }
        } else {
            sender.sendMessage("This command can only be executed by players!");
        }
    }
}

