/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.commands;

import java.util.ArrayList;
import me.leothepro555.skills.commands.SkillsCommand;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.skillsevents.BonusType;
import me.leothepro555.skills.skillsevents.SkillsEvent;
import me.leothepro555.skills.stats.StatType;
import me.leothepro555.skills.utils.TimeUtils;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandInfo
extends SkillsCommand {
    @Override
    public void runCommand(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            Skills plugin = Skills.get();
            p.sendMessage(ChatColor.GOLD + "==========[ " + Skills.getLang().parseFirstString(info.getSkill().getLanguageName()) + " ]=========");
            ArrayList<BonusType> activeBonuses = info.getBonusList();
            if (activeBonuses.size() > 0) {
                for (BonusType type : activeBonuses) {
                    String time = TimeUtils.parseTimeSeconds(type.getTimeLeftInSeconds());
                    LanguageSupport.Languages lang = LanguageSupport.Languages.Command_Info_EXP_Bonus;
                    if (type.getType() == SkillsEvent.SkillsEventType.SOUL) {
                        lang = LanguageSupport.Languages.Command_Info_Soul_Bonus;
                    }
                    sender.sendMessage(String.valueOf(Skills.getLang().parseFirstString(lang)) + time);
                }
            }
            p.sendMessage(ChatColor.AQUA + Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_Info_Souls) + ChatColor.YELLOW + info.getSouls());
            p.sendMessage(ChatColor.AQUA + Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_Info_Level) + ChatColor.YELLOW + info.getLevel());
            p.sendMessage(ChatColor.GOLD + "STR" + ChatColor.AQUA + " | " + ChatColor.LIGHT_PURPLE + "DEX" + ChatColor.AQUA + " | " + ChatColor.BLUE + "INT" + ChatColor.AQUA + " | " + ChatColor.RED + "DEF" + ChatColor.AQUA);
            p.sendMessage(ChatColor.GOLD + info.getStat(StatType.STR) + ChatColor.AQUA + " | " + ChatColor.LIGHT_PURPLE + info.getStat(StatType.DEX) + ChatColor.AQUA + " | " + ChatColor.BLUE + info.getStat(StatType.INT) + ChatColor.AQUA + " | " + ChatColor.RED + info.getStat(StatType.DEF));
            p.sendMessage(ChatColor.GOLD + "=========================");
        } else {
            sender.sendMessage(ChatColor.RED + "Only players can use /skill info");
        }
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return true;
    }

    @Override
    public String getDescription() {
        return Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Info);
    }
}

