/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.commands;

import me.leothepro555.skills.commands.SkillsCommand;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.skillsevents.BonusType;
import me.leothepro555.skills.skillsevents.SkillsEvent;
import me.leothepro555.skills.utils.MathEval;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandGiveBonus
extends SkillsCommand {
    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission("skills.givebonus");
    }

    @Override
    public String getDescription() {
        return Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_GiveBonus);
    }

    @Override
    public void runCommand(CommandSender sender, String[] args) {
        if (args.length == 5) {
            try {
                OfflinePlayer p = Bukkit.getOfflinePlayer((String)args[1]);
                if (p == null) {
                    sender.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_See_Player_Doesnt_Exist));
                    return;
                }
                SkillsEvent.SkillsEventType bonusType = SkillsEvent.SkillsEventType.fromString(args[2]);
                if (bonusType == null) {
                    sender.sendMessage(ChatColor.RED + "Usage: /skill givebonus [player] [exp/soul] [time in minutes] [multiplier]");
                    return;
                }
                int time = Integer.parseInt(args[3]) * 60;
                String multiplier = args[4];
                if (!multiplier.contains("exp") && bonusType == SkillsEvent.SkillsEventType.EXP && !multiplier.contains("soul") && bonusType == SkillsEvent.SkillsEventType.SOUL) {
                    sender.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_GiveBonus_Multiplier_Error));
                    return;
                }
                try {
                    new MathEval().evaluate(multiplier.replaceAll("exp", "1").replaceAll("soul", "1"));
                }
                catch (Throwable e) {
                    sender.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_GiveBonus_Multiplier_Invalid));
                    return;
                }
                BonusType type = new BonusType(p.getUniqueId(), bonusType, multiplier, time);
                PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo(p);
                info.addBonus(type);
                sender.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_GiveBonus_Confirmation).replaceAll("%player%", p.getName()).replaceAll("%time%", "" + time / 60));
                if (p.isOnline()) {
                    ((Player)p).sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_GiveBonus_Message).replaceAll("%time%", "" + time / 60));
                }
            }
            catch (NumberFormatException e) {
                sender.sendMessage(ChatColor.RED + "Usage: /skill givebonus [player] [exp/soul] [time in minutes] [multiplier]");
            }
        } else {
            sender.sendMessage(ChatColor.RED + "Usage: /skill givebonus [player] [exp/soul] [time in minutes] [multiplier]");
        }
    }
}

