/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.events.CustomHudChangeEvent;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skilltype.ScalingType;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class VampirePassive
extends Ability {
    public VampirePassive() {
        this.isPassive = true;
        this.saveIndex = 30;
        this.langTitle = LanguageSupport.Languages.Skill_Passive_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Vampire_Passive;
        this.scaling = SkillsConfig.ConfigOption.SCALING_VAMPIRE_PASSIVE.getString();
        this.costScaling = "0";
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("vampire");
    }

    @EventHandler
    public void onVampireAttack(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getDamager();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof VampirePassive) {
                    double blood = info.getActiveStatType(ScalingType.ENERGY);
                    double maxBlood = info.getScalingType(ScalingType.ENERGY);
                    int percen = (int)(blood / 2.0 * ab.getScaling(info));
                    double multiplier = 1.0f + (float)percen / 100.0f;
                    event.setDamage(event.getDamage() * multiplier);
                    if (blood + 3.0 >= maxBlood) {
                        info.setActiveStatType(ScalingType.ENERGY, maxBlood);
                    } else {
                        info.setActiveStatType(ScalingType.ENERGY, blood + 3.0);
                    }
                    CustomHudChangeEvent ev = new CustomHudChangeEvent(p);
                    Bukkit.getPluginManager().callEvent((Event)ev);
                    break;
                }
                ++n2;
            }
        }
    }
}

