/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import java.util.HashMap;
import java.util.UUID;
import me.leothepro555.skills.abilities.ActiveAbility;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class VampireEternalDarkness
extends ActiveAbility {
    public HashMap<UUID, LivingEntity> eternalDarkness = new HashMap();
    public HashMap<UUID, Integer> activeTimerCount = new HashMap();

    public VampireEternalDarkness() {
        this.isPassive = false;
        this.saveIndex = 34;
        this.langTitle = LanguageSupport.Languages.Skill_Vampire_EternalDarkness_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Vampire_EternalDarkness;
        this.scaling = SkillsConfig.ConfigOption.SCALING_VAMPIRE_ETERNALDARKNESS.getString();
        this.abilityReady = LanguageSupport.Languages.Skill_Vampire_Ready_Activation_Message;
        this.abilityIdle = LanguageSupport.Languages.Skill_Vampire_NotReady_Activation_Message;
        this.abilityActivate = LanguageSupport.Languages.Skill_Vampire_Active_Activation_Message;
        this.abilityFinished = LanguageSupport.Languages.Skill_Vampire_Active_Finished_Message;
        this.cooldown = SkillsConfig.ConfigOption.VAMPIRE_ETERNALDARKNESS_COOLDOWN.getInt();
        this.costScaling = SkillsConfig.ConfigOption.VAMPIRE_ETERNALDARKNESS_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("vampire");
    }

    @EventHandler
    public void onVampireAttack(final EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            final Player p = (Player)event.getDamager();
            final PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            if (!info.getSkill().getConfigName().equals(this.getType().getConfigName())) {
                return;
            }
            if (event.isCancelled()) {
                return;
            }
            if (this.isSkillReady(p)) {
                this.useSkill(p);
                this.eternalDarkness.put(p.getUniqueId(), (LivingEntity)event.getEntity());
                this.activeTimerCount.put(event.getEntity().getUniqueId(), 0);
                new BukkitRunnable(){

                    public void run() {
                        int time;
                        int i = VampireEternalDarkness.this.activeTimerCount.get(event.getEntity().getUniqueId());
                        if (i < (time = (int)info.getAbilityScaling(VampireEternalDarkness.class))) {
                            VampireEternalDarkness.this.activeTimerCount.put(event.getEntity().getUniqueId(), ++i);
                        } else {
                            VampireEternalDarkness.this.eternalDarkness.remove(p.getUniqueId());
                            Skills.get();
                            p.sendMessage(Skills.getLang().parseFirstString(VampireEternalDarkness.this.abilityFinished));
                            this.cancel();
                        }
                    }
                }.runTaskTimer((Plugin)Skills.get(), 0L, 20L);
            }
            if (this.eternalDarkness.containsKey(p.getUniqueId())) {
                ((LivingEntity)event.getEntity()).addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0));
            }
        }
    }

    @EventHandler
    public void onVampireDamaged(EntityDamageEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (this.eternalDarkness.containsKey(event.getEntity().getUniqueId())) {
            event.setDamage(0.0);
        }
    }
}

