/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.events.SkillEnergyChangeEvent;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.MathUtil;
import me.leothepro555.skilltype.ScalingType;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;

public class VampireBloodWell
extends Ability {
    public VampireBloodWell() {
        this.isPassive = false;
        this.saveIndex = 32;
        this.langTitle = LanguageSupport.Languages.Skill_Vampire_BloodWell_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Vampire_BloodWell;
        this.scaling = SkillsConfig.ConfigOption.SCALING_VAMPIRE_BLOODWELL.getString();
        this.costScaling = SkillsConfig.ConfigOption.VAMPIRE_BLOODWELL_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("vampire");
    }

    @EventHandler
    public void onVampireHeal(SkillEnergyChangeEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getPlayer().getWorld().getName())) {
            return;
        }
        Player p = event.getPlayer();
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        if (info.isDisabled(this)) {
            return;
        }
        Ability[] abilityArray = info.getSkill().getAbilities();
        int n = abilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ability ab = abilityArray[n2];
            if (ab instanceof VampireBloodWell) {
                if (info.getSkillImprovementLevel(ab) == 0) {
                    return;
                }
                double chance = ab.getScaling(info);
                double currBlood = info.getActiveStatType(ScalingType.ENERGY);
                if (currBlood < event.getAmount()) {
                    return;
                }
                if (!((double)MathUtil.randInt(0, 100) < chance)) break;
                event.setCancelled(true);
                break;
            }
            ++n2;
        }
    }
}

