/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.events.CustomHudChangeEvent;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.HealthUtils;
import me.leothepro555.skills.utils.MathUtil;
import me.leothepro555.skilltype.ScalingType;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class VampireBloodLust
extends Ability {
    public VampireBloodLust() {
        this.isPassive = false;
        this.saveIndex = 31;
        this.langTitle = LanguageSupport.Languages.Skill_Vampire_BloodLust_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Vampire_BloodLust;
        this.scaling = SkillsConfig.ConfigOption.SCALING_VAMPIRE_BLOODLUST.getString();
        this.costScaling = SkillsConfig.ConfigOption.VAMPIRE_BLOODLUST_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("vampire");
    }

    @EventHandler
    public void onVampireHeal(EntityRegainHealthEvent event) {
        if (event.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED) {
            return;
        }
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            if (ExternalHandler.isCitizen(event.getEntity())) {
                return;
            }
            Player p = (Player)event.getEntity();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof VampireBloodLust) {
                    double maxBlood;
                    if (info.getSkillImprovementLevel(ab) < 2) {
                        return;
                    }
                    double blood = info.getActiveStatType(ScalingType.ENERGY);
                    if (blood < 0.7 * (maxBlood = info.getScalingType(ScalingType.ENERGY))) {
                        return;
                    }
                    event.setAmount(event.getAmount() * 3.0);
                    break;
                }
                ++n2;
            }
        }
    }

    @EventHandler
    public void onVampireAttack(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getDamager();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof VampireBloodLust) {
                    double maxBlood;
                    if (info.getSkillImprovementLevel(ab) == 0) {
                        return;
                    }
                    double blood = info.getActiveStatType(ScalingType.ENERGY);
                    if (blood < 0.7 * (maxBlood = info.getScalingType(ScalingType.ENERGY))) {
                        return;
                    }
                    double multiplier = ab.getScaling(info);
                    event.setDamage(event.getDamage() * ((100.0 + multiplier) / 100.0));
                    if (info.getSkillImprovementLevel(ab) > 2) {
                        double chance = blood;
                        if (chance > 30.0) {
                            chance = 30.0;
                        }
                        if ((double)MathUtil.randInt(0, 100) < chance) {
                            HealthUtils.healPlayer(p, 2.0);
                        }
                    }
                    CustomHudChangeEvent ev = new CustomHudChangeEvent(p);
                    Bukkit.getPluginManager().callEvent((Event)ev);
                    break;
                }
                ++n2;
            }
        }
    }
}

