/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.damage.CustomPoisonor;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class VampireBleed
extends Ability {
    public VampireBleed() {
        this.isPassive = false;
        this.saveIndex = 33;
        this.langTitle = LanguageSupport.Languages.Skill_Vampire_Bleed_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Vampire_Bleed;
        this.scaling = SkillsConfig.ConfigOption.SCALING_VAMPIRE_BLEED.getString();
        this.costScaling = SkillsConfig.ConfigOption.VAMPIRE_BLEED_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("vampire");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVampireAttack(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getDamager();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof VampireBleed) {
                    if (info.getSkillImprovementLevel(ab) == 0) {
                        return;
                    }
                    CustomPoisonor customPoisonor = new CustomPoisonor(p, (LivingEntity)event.getEntity(), 1, (int)ab.getScaling(info), 1);
                }
                ++n2;
            }
        }
    }
}

