/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import java.util.HashMap;
import java.util.UUID;
import me.leothepro555.skills.abilities.ActiveAbility;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.MathUtil;
import me.leothepro555.skills.utils.VersionSupport;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SwordsmanThousandCuts
extends ActiveAbility {
    public HashMap<UUID, Integer> activeTrapcount = new HashMap();
    public HashMap<UUID, Location> activeLocation = new HashMap();
    public HashMap<UUID, LivingEntity> thousandcuts = new HashMap();

    public SwordsmanThousandCuts() {
        this.isPassive = false;
        this.saveIndex = 4;
        this.langTitle = LanguageSupport.Languages.Skill_Swordsman_ThousandCuts_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Swordsman_ThousandCuts;
        this.scaling = SkillsConfig.ConfigOption.SCALING_SWORDSMAN_THOUSANDCUTS.getString();
        this.abilityReady = LanguageSupport.Languages.Skill_Swordsman_Ready_Activation_Message;
        this.abilityIdle = LanguageSupport.Languages.Skill_Swordsman_NotReady_Activation_Message;
        this.abilityActivate = LanguageSupport.Languages.Skill_Swordsman_Active_Activation_Message;
        this.abilityFinished = LanguageSupport.Languages.Skill_Swordsman_Active_Finished_Message;
        this.weaponType = "SWORD";
        this.energyCost = SkillsConfig.ConfigOption.SWORDSMAN_THOUSANDCUTS_ENERGY_COST.getInt();
        this.cooldown = SkillsConfig.ConfigOption.SWORDSMAN_THOUSANDCUTS_COOLDOWN.getInt();
        this.costScaling = SkillsConfig.ConfigOption.SWORDSMAN_THOUSANDCUTS_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("swordsman");
    }

    @EventHandler
    public void onSwordsmanAttack(final EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            final Player p = (Player)event.getDamager();
            if (p.getItemInHand() == null) {
                return;
            }
            if (!p.getItemInHand().getType().toString().contains(this.weaponType)) {
                return;
            }
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (!info.getSkill().getConfigName().equals(this.getType().getConfigName())) {
                return;
            }
            if (info.isDisabled(this)) {
                return;
            }
            if (this.thousandcuts.containsKey(p.getUniqueId()) && this.thousandcuts.get(p.getUniqueId()).equals(event.getEntity())) {
                event.setCancelled(false);
                double chance = this.getScaling(info);
                event.setDamage(event.getDamage() + chance);
                this.createCutAnimation(event.getEntity());
            }
            if (event.isCancelled()) {
                return;
            }
            if (this.isSkillReady(p)) {
                this.useSkill(p);
                this.thousandcuts.put(p.getUniqueId(), (LivingEntity)event.getEntity());
                this.activeTrapcount.put(event.getEntity().getUniqueId(), 0);
                this.activeLocation.put(event.getEntity().getUniqueId(), event.getEntity().getLocation());
                new BukkitRunnable(){

                    public void run() {
                        Skills.logDebug("Swordsman Active loop");
                        if (!SwordsmanThousandCuts.this.activeTrapcount.containsKey(event.getEntity().getUniqueId())) {
                            return;
                        }
                        int i = SwordsmanThousandCuts.this.activeTrapcount.get(event.getEntity().getUniqueId());
                        if (!event.getEntity().isDead() && event.getEntity().isValid() && i < 8) {
                            SwordsmanThousandCuts.this.activeTrapcount.put(event.getEntity().getUniqueId(), ++i);
                            Location loc = new Location(SwordsmanThousandCuts.this.activeLocation.get(event.getEntity().getUniqueId()).getWorld(), SwordsmanThousandCuts.this.activeLocation.get(event.getEntity().getUniqueId()).getX(), SwordsmanThousandCuts.this.activeLocation.get(event.getEntity().getUniqueId()).getY(), SwordsmanThousandCuts.this.activeLocation.get(event.getEntity().getUniqueId()).getZ(), (float)MathUtil.randInt(0, 360), (float)MathUtil.randInt(-90, 90));
                            event.getEntity().teleport(loc, PlayerTeleportEvent.TeleportCause.PLUGIN);
                        } else {
                            SwordsmanThousandCuts.this.thousandcuts.remove(p.getUniqueId());
                            SwordsmanThousandCuts.this.activeTrapcount.remove(event.getEntity().getUniqueId());
                            SwordsmanThousandCuts.this.activeLocation.remove(event.getEntity().getUniqueId());
                            Skills.get();
                            p.sendMessage(Skills.getLang().parseFirstString(SwordsmanThousandCuts.this.abilityFinished));
                            this.cancel();
                        }
                    }
                }.runTaskTimer((Plugin)Skills.get(), 0L, 5L);
            }
        }
    }

    private void createCutAnimation(Entity e) {
        Location loc1 = e.getLocation().add((double)MathUtil.randInt(-3, 3), (double)MathUtil.randInt(0, 2), (double)MathUtil.randInt(-3, 3));
        Location loc2 = e.getLocation().add((double)MathUtil.randInt(-3, 3), (double)MathUtil.randInt(0, 2), (double)MathUtil.randInt(-3, 3));
        double dist = Math.abs(loc1.distance(loc2));
        int i = -1;
        while ((double)i < (loc1.distance(loc2) + 2.0) * 10.0) {
            double delta = (double)i / 10.0 / dist;
            double x = (1.0 - delta) * loc1.getX() + delta * (loc2.getX() + 0.5);
            double y = (1.0 - delta) * loc1.getY() + delta * (loc2.getY() + 0.5);
            double z = (1.0 - delta) * loc1.getZ() + delta * (loc2.getZ() + 0.5);
            Location l = new Location(loc1.getWorld(), x, y, z);
            VersionSupport.spawnColouredDust(l);
            ++i;
        }
    }
}

