/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.damage.LastHitManager;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.stats.StatType;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class SwordsmanParry
extends Ability {
    public SwordsmanParry() {
        this.isPassive = false;
        this.saveIndex = 2;
        this.langTitle = LanguageSupport.Languages.Skill_Swordsman_Parry_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Swordsman_Parry;
        this.scaling = SkillsConfig.ConfigOption.SCALING_SWORDSMAN_PARRY.getString();
        this.costScaling = SkillsConfig.ConfigOption.SWORDSMAN_PARRY_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("swordsman");
    }

    @EventHandler
    public void onSwordsmanDefend(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getEntity();
            if (p.getItemInHand() == null) {
                return;
            }
            if (!p.getItemInHand().getType().toString().contains("SWORD")) {
                return;
            }
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof SwordsmanParry) {
                    PlayerInfo attackerInfo;
                    int strattacker;
                    int strdefender;
                    if (info.getSkillImprovementLevel(ab) == 0) {
                        return;
                    }
                    if (event.getDamager() instanceof Player ? (strdefender = info.getStat(StatType.STR)) <= (strattacker = (attackerInfo = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)((Player)event.getDamager()))).getStat(StatType.STR)) : !(event.getDamager() instanceof LivingEntity)) {
                        return;
                    }
                    double multiplier = ab.getScaling(info) / 100.0;
                    if (multiplier == 0.0) {
                        return;
                    }
                    LastHitManager.damageLivingEntity((LivingEntity)event.getDamager(), p, event.getDamage() * multiplier);
                    break;
                }
                ++n2;
            }
        }
    }
}

