/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.ProbabilityTool;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class SwordsmanDodge
extends Ability {
    public SwordsmanDodge() {
        this.isPassive = false;
        this.saveIndex = 1;
        this.langTitle = LanguageSupport.Languages.Skill_Swordsman_Dodge_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Swordsman_Dodge;
        this.scaling = SkillsConfig.ConfigOption.SCALING_SWORDSMAN_DODGE.getString();
        this.costScaling = SkillsConfig.ConfigOption.SWORDSMAN_DODGE_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("swordsman");
    }

    @EventHandler
    public void onSwordsmanDefend(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getEntity();
            if (p.getItemInHand() == null) {
                return;
            }
            if (!p.getItemInHand().getType().toString().contains("SWORD")) {
                return;
            }
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof SwordsmanDodge) {
                    if (info.getSkillImprovementLevel(ab) == 0) {
                        return;
                    }
                    double chance = ab.getScaling(info);
                    if (chance > 40.0) {
                        chance = 40.0;
                    }
                    if ((double)ProbabilityTool.randInt(0, 100) <= chance) {
                        event.setDamage(0.0);
                        event.setCancelled(true);
                        p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Swordsman_Dodge_Message));
                        if (event.getDamager() instanceof Player) {
                            ((Player)event.getDamager()).sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Swordsman_Dodge_Opponent_Message));
                        }
                    }
                }
                ++n2;
            }
        }
    }
}

