/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.damage.LastHitManager;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.MathUtil;
import me.leothepro555.skilltype.SkillType;
import me.leothepro555.skilltype.SkillTypeManager;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class MageReflect
extends Ability {
    public MageReflect() {
        this.isPassive = false;
        this.saveIndex = 11;
        this.langTitle = LanguageSupport.Languages.Skill_Mage_Reflect_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Mage_Reflect;
        this.scaling = SkillsConfig.ConfigOption.SCALING_MAGE_REFLECT.getString();
        this.costScaling = SkillsConfig.ConfigOption.MAGE_REFLECT_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("mage");
    }

    @EventHandler
    public void onMageDefend(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getEntity() instanceof Player && event.getDamager() instanceof LivingEntity) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getEntity();
            if (p.getItemInHand() == null) {
                return;
            }
            if (!p.getItemInHand().getType().toString().contains("HOE")) {
                return;
            }
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof MageReflect) {
                    if (info.getSkillImprovementLevel(ab) == 0) {
                        return;
                    }
                    if (MathUtil.randInt(0, 100) >= SkillTypeManager.defineHoeChance(p.getItemInHand())) break;
                    double chance = ab.getScaling(info);
                    LastHitManager.damageLivingEntity((LivingEntity)event.getDamager(), p, chance);
                    break;
                }
                ++n2;
            }
        }
    }
}

