/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.events.CustomHudChangeEvent;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skilltype.ScalingType;
import me.leothepro555.skilltype.SkillType;
import me.leothepro555.skilltype.SkillTypeManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class MagePassive
extends Ability {
    public MagePassive() {
        this.isPassive = true;
        this.saveIndex = 10;
        this.langTitle = LanguageSupport.Languages.Skill_Passive_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Mage_PassiveV2;
        this.scaling = SkillsConfig.ConfigOption.SCALING_MAGE_PASSIVE.getString();
        this.costScaling = "0";
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("mage");
    }

    @EventHandler
    public void onMageAttack(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getDamager();
            if (p.getItemInHand() == null) {
                return;
            }
            if (!p.getItemInHand().getType().toString().contains("HOE")) {
                return;
            }
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof MagePassive) {
                    int amtToAdd = (int)ab.getScaling(info);
                    if (info.getActiveStatType(ScalingType.ENERGY) + (double)amtToAdd < info.getScalingType(ScalingType.ENERGY)) {
                        info.setActiveStatType(ScalingType.ENERGY, info.getActiveStatType(ScalingType.ENERGY) + (double)amtToAdd);
                    } else {
                        info.setActiveStatType(ScalingType.ENERGY, info.getScalingType(ScalingType.ENERGY));
                    }
                    CustomHudChangeEvent hudevent = new CustomHudChangeEvent(p);
                    Bukkit.getPluginManager().callEvent((Event)hudevent);
                    event.setDamage(event.getDamage() + (double)SkillTypeManager.defineHoeDamage(p.getItemInHand()));
                }
                ++n2;
            }
        }
    }
}

