/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skilltype.ScalingType;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class MageHealSpell
extends Ability {
    public MageHealSpell() {
        this.isPassive = false;
        this.saveIndex = 13;
        this.langTitle = LanguageSupport.Languages.Skill_Mage_HealSpell_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Mage_HealSpell;
        this.scaling = SkillsConfig.ConfigOption.SCALING_MAGE_HEALSPELL.getString();
        this.costScaling = SkillsConfig.ConfigOption.MAGE_HEALSPELL_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("mage");
    }

    @EventHandler
    public void onMageAttack(EntityRegainHealthEvent event) {
        if (event.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED && event.getRegainReason() != EntityRegainHealthEvent.RegainReason.REGEN) {
            return;
        }
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            if (ExternalHandler.isCitizen(event.getEntity())) {
                return;
            }
            Player p = (Player)event.getEntity();
            if (p.getItemInHand() == null) {
                return;
            }
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof MageHealSpell) {
                    if (info.getSkillImprovementLevel(ab) == 0) {
                        return;
                    }
                    int extra = (int)info.getActiveStatType(ScalingType.ENERGY) / 10;
                    event.setAmount(event.getAmount() + (double)extra * ab.getScaling(info));
                    break;
                }
                ++n2;
            }
        }
    }
}

