/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.MathUtil;
import me.leothepro555.skilltype.SkillType;
import me.leothepro555.skilltype.SkillTypeManager;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class MageExplosionSpell
extends Ability {
    public MageExplosionSpell() {
        this.isPassive = false;
        this.saveIndex = 12;
        this.langTitle = LanguageSupport.Languages.Skill_Mage_ExplosionSpell_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Mage_ExplosionSpell;
        this.scaling = SkillsConfig.ConfigOption.SCALING_MAGE_EXPLOSIONSPELL.getString();
        this.costScaling = SkillsConfig.ConfigOption.MAGE_EXPLOSIONSPELL_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("mage");
    }

    @EventHandler
    public void onMageAttack(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getDamager();
            if (p.getItemInHand() == null) {
                return;
            }
            if (!p.getItemInHand().getType().toString().contains("HOE")) {
                return;
            }
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof MageExplosionSpell) {
                    if (info.getSkillImprovementLevel(ab) == 0) {
                        return;
                    }
                    if (MathUtil.randInt(0, 100) >= SkillTypeManager.defineHoeChance(p.getItemInHand())) break;
                    double chance = ab.getScaling(info);
                    double multiplier = 1.0 + chance / 100.0;
                    event.setDamage(event.getDamage() * multiplier);
                    p.getWorld().spawnParticle(Particle.EXPLOSION_HUGE, event.getEntity().getLocation(), 1);
                    break;
                }
                ++n2;
            }
        }
    }
}

