/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.leothepro555.skills.abilities.ActiveAbility;
import me.leothepro555.skills.damage.LastHitManager;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.events.CustomHudChangeEvent;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.Cooldown;
import me.leothepro555.skills.utils.LoreUtil;
import me.leothepro555.skills.utils.VersionSupport;
import me.leothepro555.skills.utils.XMaterial;
import me.leothepro555.skilltype.ScalingType;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MageEnergyFlux
extends ActiveAbility {
    public MageEnergyFlux() {
        this.isPassive = false;
        this.saveIndex = 14;
        this.abilityNeedMoreEnergy = LanguageSupport.Languages.Misc_Not_enough_Mana;
        this.langTitle = LanguageSupport.Languages.Skill_Mage_EnergyFlux_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Mage_EnergyFluxV2;
        this.scaling = SkillsConfig.ConfigOption.SCALING_MAGE_ENERGYFLUX.getString();
        this.abilityReady = null;
        this.abilityIdle = LanguageSupport.Languages.Skill_Mage_NotReady_Activation_Message;
        this.abilityActivate = null;
        this.abilityFinished = null;
        this.activateOnReady = true;
        this.weaponType = "HOE";
        this.energyCost = SkillsConfig.ConfigOption.MAGE_ENERGYFLUX_ENERGY_COST.getInt();
        this.cooldown = SkillsConfig.ConfigOption.MAGE_ENERGYFLUX_COOLDOWN.getInt();
        this.costScaling = SkillsConfig.ConfigOption.MAGE_ENERGYFLUX_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("mage");
    }

    @Override
    public void useSkill(Player p) {
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        if (info.isDisabled(this)) {
            return;
        }
        double curr = info.getActiveStatType(ScalingType.ENERGY);
        info.setActiveStatType(ScalingType.ENERGY, curr - (double)this.energyCost);
        info.setActiveReady(false);
        info.setActiveStatType(ScalingType.ACTIVECD, this.cooldown);
        CustomHudChangeEvent hudevent = new CustomHudChangeEvent(p);
        Bukkit.getPluginManager().callEvent((Event)hudevent);
        Location blockloc = p.getLocation().clone().add(p.getLocation().getDirection().multiply(100));
        this.fireEnergyFlux(p.getLocation().add(0.0, 1.0, 0.0), blockloc, 100, p);
    }

    @Override
    public ItemStack getDescriptiveItem(PlayerInfo info) {
        ItemStack item = new ItemStack(XMaterial.FIREWORK_STAR.parseMaterial());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Skills.getLang().parseFirstString(this.langTitle));
        ArrayList<String> lore = new ArrayList<String>();
        int level = info.getSkillImprovementLevel(this);
        ChatColor color = this.getColourForString(this.scaling);
        String desc = Skills.getLang().parseFirstString(this.langDesc).replaceAll("%amount%", "" + color + (int)this.getScaling(info)).replaceAll("%damage%", "" + color + (int)this.getScaling(info)).replaceAll("%chance%", "" + color + (int)this.getScaling(info)).replaceAll("%time%", "" + color + (int)this.getScaling(info)).replaceAll("%cooldown%", "" + color + this.cooldown).replaceAll("%calculatedamt%", "" + color + (int)this.getScaling(info));
        lore = LoreUtil.addLore(desc, lore, ChatColor.AQUA);
        if (!this.isPassive) {
            if (level < 3) {
                int cost = this.getSoulCost(level);
                Skills.get();
                lore = LoreUtil.addLore(String.valueOf(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Improve_Cost)) + cost, lore, ChatColor.RED);
            }
            lore = LoreUtil.addLore(ChatColor.AQUA + "LvL: " + ChatColor.YELLOW + level + "/3", lore, ChatColor.AQUA);
        }
        if (this.isPassive || level >= 3) {
            if (!info.isDisabled(this)) {
                Skills.get();
                lore = LoreUtil.addLore(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Disable_Ability), lore, ChatColor.RED);
            } else if (info.isDisabled(this)) {
                Skills.get();
                lore = LoreUtil.addLore(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Enable_Ability), lore, ChatColor.GREEN);
            }
        }
        String scales = Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Skill_Affected_By);
        String append = "";
        if (this.scaling.contains("str")) {
            append = String.valueOf(append) + ChatColor.GOLD + "STR ";
        }
        if (this.scaling.contains("int")) {
            append = String.valueOf(append) + ChatColor.BLUE + "INT ";
        }
        if (this.scaling.contains("dex")) {
            append = String.valueOf(append) + ChatColor.LIGHT_PURPLE + "DEX";
        }
        if (this.scaling.contains("def")) {
            append = String.valueOf(append) + ChatColor.RED + "DEF ";
        }
        if (!append.equals("")) {
            scales = scales.replaceAll("%stat%", append);
            lore = LoreUtil.addLore(scales, lore, ChatColor.AQUA);
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public void fireEnergyFlux(Location start, Location end, int repeatCount, Player p) {
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        double dist = Math.abs(end.distance(start));
        List entities = p.getNearbyEntities(10.0, 10.0, 10.0);
        ArrayList<UUID> hit = new ArrayList<UUID>();
        int i = -1;
        while (i < repeatCount) {
            Block block;
            double delta = (double)i / 10.0 / dist;
            double x = (1.0 - delta) * start.getX() + delta * (end.getX() + 0.5);
            double y = (1.0 - delta) * start.getY() + delta * (end.getY() + 0.5);
            double z = (1.0 - delta) * start.getZ() + delta * (end.getZ() + 0.5);
            Location l = new Location(start.getWorld(), x, y, z);
            VersionSupport.spawnColouredDust(l);
            if (i > 5 && (block = start.getWorld().getBlockAt(l)).getType().isSolid()) break;
            ArrayList<UUID> targets = new ArrayList<UUID>();
            for (Entity entity : entities) {
                Cooldown c;
                if (hit.contains(entity.getUniqueId()) || !(entity instanceof LivingEntity) || entity == p || !(l.distance(((LivingEntity)entity).getEyeLocation()) < 2.0) || targets.contains(entity.getUniqueId())) continue;
                targets.add(entity.getUniqueId());
                double damage = info.getAbilityScaling(MageEnergyFlux.class);
                if (!Cooldown.isInCooldown(entity.getUniqueId(), "mageEnergyFlux")) {
                    LastHitManager.damageLivingEntity((LivingEntity)entity, p, damage);
                    c = new Cooldown(entity.getUniqueId(), "mageEnergyFlux", this.cooldown);
                    c.start();
                } else {
                    LastHitManager.damageLivingEntity((LivingEntity)entity, p, 0.5 * damage);
                    c = new Cooldown(entity.getUniqueId(), "mageEnergyFlux", this.cooldown);
                    c.start();
                }
                hit.add(entity.getUniqueId());
                targets.remove(entity.getUniqueId());
            }
            ++i;
        }
    }
}

