/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import java.util.HashMap;
import java.util.UUID;
import me.leothepro555.skills.abilities.ActiveAbility;
import me.leothepro555.skills.damage.LastHitManager;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.VersionSupport;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class JuggernautThrow
extends ActiveAbility {
    public HashMap<UUID, Integer> activeCarryCount = new HashMap();
    public HashMap<UUID, LivingEntity> throwpairs = new HashMap();

    public JuggernautThrow() {
        this.isPassive = false;
        this.saveIndex = 24;
        this.langTitle = LanguageSupport.Languages.Skill_Juggernaut_Throw_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Juggernaut_Throw;
        this.scaling = SkillsConfig.ConfigOption.SCALING_JUGGERNAUT_THROW.getString();
        this.abilityReady = LanguageSupport.Languages.Skill_Juggernaut_Active_Ready_Message;
        this.abilityIdle = LanguageSupport.Languages.Skill_Juggernaut_Active_NotReady_Message;
        this.abilityActivate = LanguageSupport.Languages.Skill_Juggernaut_Active_Activated_Message;
        this.abilityFinished = LanguageSupport.Languages.Skill_Juggernaut_Active_Throw_Success;
        this.energyCost = SkillsConfig.ConfigOption.JUGGERNAUT_THROW_ENERGY_COST.getInt();
        this.cooldown = SkillsConfig.ConfigOption.JUGGERNAUT_THROW_COOLDOWN.getInt();
        this.costScaling = SkillsConfig.ConfigOption.JUGGERNAUT_THROW_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("juggernaut");
    }

    @EventHandler
    public void onJuggernautAttack(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getDamager();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (!info.getSkill().getConfigName().equals(this.getType().getConfigName())) {
                return;
            }
            if (info.isDisabled(this)) {
                return;
            }
            if (event.isCancelled()) {
                return;
            }
            if (!info.isActiveReady()) {
                return;
            }
            this.useSkill(p);
            this.carryEntity(p, info, (LivingEntity)event.getEntity());
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEntityAttemptDamage(EntityDamageByEntityEvent event) {
        if (SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            if (this.throwpairs.containsKey(event.getEntity().getUniqueId())) {
                event.setDamage(event.getDamage() / 2.0);
            }
            if (this.throwpairs.containsKey(event.getDamager().getUniqueId()) || this.throwpairs.containsValue(event.getDamager())) {
                event.setCancelled(true);
            }
        }
    }

    private void carryEntity(final Player p, final PlayerInfo info, final LivingEntity e) {
        this.throwpairs.put(p.getUniqueId(), e);
        p.setPassenger((Entity)e);
        Skills.get();
        p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Juggernaut_Active_Activated_Message));
        this.activeCarryCount.put(e.getUniqueId(), 0);
        new BukkitRunnable(){

            public void run() {
                int i = JuggernautThrow.this.activeCarryCount.get(e.getUniqueId());
                if (!e.isDead() && e.isValid() && i < 3 && !p.isDead() && p.isValid()) {
                    JuggernautThrow.this.activeCarryCount.put(e.getUniqueId(), ++i);
                    if (!VersionSupport.isPassenger((Entity)p, (Entity)e)) {
                        p.setPassenger((Entity)e);
                    }
                    Skills.get();
                    p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Juggernaut_Active_Throw_Message_Countdown).replace("%countdown%", "" + (3 - i)));
                } else {
                    JuggernautThrow.this.throwpairs.remove(p.getUniqueId());
                    JuggernautThrow.this.activeCarryCount.remove(e.getUniqueId());
                    Skills.get();
                    p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Juggernaut_Active_Throw_Success));
                    this.cancel();
                    if (!VersionSupport.isPassenger((Entity)p, (Entity)e)) {
                        p.setPassenger((Entity)e);
                    }
                    p.eject();
                    e.eject();
                    e.teleport(p.getLocation().add(0.0, 1.0, 0.0));
                    double pitch = (double)(p.getLocation().getPitch() + 90.0f) * Math.PI / 180.0;
                    double yaw = (double)(p.getLocation().getYaw() + 90.0f) * Math.PI / 180.0;
                    double x = Math.sin(pitch) * Math.cos(yaw);
                    double y = Math.sin(pitch) * Math.sin(yaw);
                    double z = Math.cos(pitch);
                    Vector vector = new Vector(x, z, y);
                    e.setVelocity(vector.multiply(2));
                    double chance = info.getAbilityScaling(JuggernautThrow.class);
                    LastHitManager.damageLivingEntity(e, p, chance);
                }
            }
        }.runTaskTimer((Plugin)Skills.get(), 0L, 20L);
    }
}

