/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class JuggernautStoneSkin
extends Ability {
    public JuggernautStoneSkin() {
        this.isPassive = false;
        this.saveIndex = 22;
        this.langTitle = LanguageSupport.Languages.Skill_Juggernaut_StoneSkin_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Juggernaut_StoneSkin;
        this.scaling = SkillsConfig.ConfigOption.SCALING_JUGGERNAUT_STONESKIN.getString();
        this.costScaling = SkillsConfig.ConfigOption.JUGGERNAUT_STONESKIN_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("juggernaut");
    }

    @EventHandler
    public void onJuggernautDefend(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getEntity();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof JuggernautStoneSkin) {
                    if (info.getSkillImprovementLevel(ab) == 0) {
                        return;
                    }
                    if (info.getSkillImprovementLevel(ab) > 0 && event.getCause() == EntityDamageEvent.DamageCause.FALL) {
                        event.setDamage(event.getDamage() / 2.0);
                    }
                    if (info.getSkillImprovementLevel(ab) > 1 && (event.getCause() == EntityDamageEvent.DamageCause.FIRE || event.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK)) {
                        event.setDamage(event.getDamage() / 2.0);
                    }
                }
                ++n2;
            }
        }
    }
}

