/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.abilities.JuggernautStoneSkin;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class JuggernautPassive
extends Ability {
    public JuggernautPassive() {
        this.isPassive = true;
        this.saveIndex = 20;
        this.langTitle = LanguageSupport.Languages.Skill_Passive_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Juggernaut_PassiveV2;
        this.scaling = SkillsConfig.ConfigOption.SCALING_JUGGERNAUT_PASSIVE.getString();
        this.costScaling = "0";
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("juggernaut");
    }

    @EventHandler
    public void onJuggernautDefend(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntity() instanceof Player && SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getEntity();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof JuggernautPassive) {
                    double amt;
                    double chance = ab.getScaling(info);
                    if (event.getDamager() instanceof Projectile && info.getSkillImprovementLevel(JuggernautStoneSkin.class) <= 2) break;
                    if (chance > 60.0) {
                        chance = 60.0;
                    }
                    if (chance < 1.0) {
                        chance = 1.0;
                    }
                    if ((amt = chance / 100.0) < 0.01) {
                        amt = 0.01;
                    }
                    double multiplier = 1.0 - amt;
                    event.setDamage(event.getDamage() * multiplier);
                    break;
                }
                ++n2;
            }
        }
    }
}

