/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class JuggernautHeavyStrikes
extends Ability {
    public JuggernautHeavyStrikes() {
        this.isPassive = false;
        this.saveIndex = 21;
        this.langTitle = LanguageSupport.Languages.Skill_Juggernaut_HeavyStrikes_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Juggernaut_HeavyStrikes;
        this.scaling = SkillsConfig.ConfigOption.SCALING_JUGGERNAUT_HEAVYSTRIKES.getString();
        this.costScaling = SkillsConfig.ConfigOption.JUGGERNAUT_HEAVYSTRIKES_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("juggernaut");
    }

    @EventHandler
    public void onJuggernautAttack(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getDamager();
            if (p.getItemInHand() == null) {
                return;
            }
            if (!p.getItemInHand().getType().toString().contains("AXE")) {
                return;
            }
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof JuggernautHeavyStrikes) {
                    if (info.getSkillImprovementLevel(ab) == 0) {
                        return;
                    }
                    double chance = ab.getScaling(info);
                    double multiplier = 1.0 + chance / 100.0;
                    event.setDamage(event.getDamage() * multiplier);
                    break;
                }
                ++n2;
            }
        }
    }
}

