/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.Cooldown;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class JuggernautAegisProtection
extends Ability {
    public JuggernautAegisProtection() {
        this.isPassive = false;
        this.saveIndex = 23;
        this.langTitle = LanguageSupport.Languages.Skill_Juggernaut_AegisProtection_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Juggernaut_AegisProtection;
        this.scaling = SkillsConfig.ConfigOption.SCALING_JUGGERNAUT_AEGISPROTECTION.getString();
        this.costScaling = SkillsConfig.ConfigOption.JUGGERNAUT_AEGISPROTECTION_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("juggernaut");
    }

    @EventHandler
    public void onJuggernautDefend(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getEntity();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof JuggernautAegisProtection) {
                    if (info.getSkillImprovementLevel(ab) == 0) {
                        return;
                    }
                    if (!Cooldown.isInCooldown(p.getUniqueId(), "juggernautaegisshield")) {
                        int chance = (int)ab.getScaling(info);
                        Cooldown c = new Cooldown(p.getUniqueId(), "juggernautaegisshield", chance);
                        c.start();
                        event.setCancelled(true);
                        Skills.get();
                        p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Juggernaut_Aegis_Success));
                        return;
                    }
                }
                ++n2;
            }
        }
    }
}

