/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class FireMagePhoenixEssence
extends Ability {
    public FireMagePhoenixEssence() {
        this.isPassive = false;
        this.saveIndex = 17;
        this.langTitle = LanguageSupport.Languages.Skill_FireMage_PhoenixEssence_Title;
        this.langDesc = LanguageSupport.Languages.Skill_FireMage_PhoenixEssence;
        this.scaling = SkillsConfig.ConfigOption.SCALING_FIREMAGE_PHOENIXESSENCE.getString();
        this.costScaling = SkillsConfig.ConfigOption.FIREMAGE_PHOENIXESSENCE_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("firemage");
    }

    @EventHandler
    public void onFireMageAttack(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
            return;
        }
        Player p = (Player)event.getDamager();
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        if (info.isDisabled(this)) {
            return;
        }
        Ability[] abilityArray = info.getSkill().getAbilities();
        int n = abilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ability ab = abilityArray[n2];
            if (ab instanceof FireMagePhoenixEssence) {
                if (info.getSkillImprovementLevel(ab) == 0) {
                    return;
                }
                int fireticks = event.getEntity().getFireTicks();
                int multipler = fireticks / 20;
                double chance = ab.getScaling(info);
                double multiplier = 1.0 + (double)multipler * chance / 100.0;
                event.setDamage(event.getDamage() * multiplier);
            }
            ++n2;
        }
    }
}

