/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.HealthUtils;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class FireMagePassive
extends Ability {
    public FireMagePassive() {
        this.isPassive = true;
        this.saveIndex = 15;
        this.langTitle = LanguageSupport.Languages.Skill_Passive_Title;
        this.langDesc = LanguageSupport.Languages.Skill_FireMage_PassiveV2;
        this.scaling = SkillsConfig.ConfigOption.SCALING_FIREMAGE_PASSIVE.getString();
        this.costScaling = "0";
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("firemage");
    }

    @EventHandler
    public void onFireMageHeal(EntityRegainHealthEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED) {
            return;
        }
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            if (ExternalHandler.isCitizen(event.getEntity())) {
                return;
            }
            Player p = (Player)event.getEntity();
            if (p.getFireTicks() <= 0) {
                return;
            }
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof FireMagePassive) {
                    event.setAmount(event.getAmount() + ab.getScaling(info));
                    break;
                }
                ++n2;
            }
        }
    }

    @EventHandler
    public void onFireDamage(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            if (ExternalHandler.isCitizen(event.getEntity())) {
                return;
            }
            Player p = (Player)event.getEntity();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof FireMagePassive) {
                    if (event.getCause() == EntityDamageEvent.DamageCause.FIRE) {
                        event.setCancelled(true);
                    }
                    if (event.getCause() != EntityDamageEvent.DamageCause.FIRE_TICK) break;
                    event.setCancelled(true);
                    HealthUtils.healPlayer(p, ab.getScaling(info));
                    break;
                }
                ++n2;
            }
        }
    }
}

