/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.ActiveAbility;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.events.CustomHudChangeEvent;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skilltype.ScalingType;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class FireMageInferno
extends ActiveAbility {
    public FireMageInferno() {
        this.isPassive = false;
        this.saveIndex = 19;
        this.abilityNeedMoreEnergy = LanguageSupport.Languages.Misc_Not_enough_Health;
        this.langTitle = LanguageSupport.Languages.Skill_FireMage_Inferno_Title;
        this.langDesc = LanguageSupport.Languages.Skill_FireMage_Inferno;
        this.scaling = SkillsConfig.ConfigOption.SCALING_FIREMAGE_INFERNO.getString();
        this.abilityReady = LanguageSupport.Languages.Skill_FireMage_Ready_Activation_Message;
        this.abilityIdle = LanguageSupport.Languages.Skill_FireMage_NotReady_Activation_Message;
        this.abilityActivate = LanguageSupport.Languages.Skill_FireMage_Activation_Message;
        this.abilityFinished = null;
        this.energyCost = SkillsConfig.ConfigOption.FIREMAGE_INFERNO_ENERGY_COST.getInt();
        this.cooldown = SkillsConfig.ConfigOption.FIREMAGE_INFERNO_COOLDOWN.getInt();
        this.costScaling = SkillsConfig.ConfigOption.FIREMAGE_INFERNO_COST.getString();
    }

    @Override
    protected void useSkill(Player p) {
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        p.damage((double)this.energyCost);
        info.setActiveReady(false);
        info.setActiveStatType(ScalingType.ACTIVECD, this.cooldown);
        CustomHudChangeEvent hudevent = new CustomHudChangeEvent(p);
        Bukkit.getPluginManager().callEvent((Event)hudevent);
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("firemage");
    }

    @EventHandler
    public void onFireMageAttack(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getDamager();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (!info.getSkill().getConfigName().equals(this.getType().getConfigName())) {
                return;
            }
            if (info.isDisabled(this)) {
                return;
            }
            if (event.isCancelled()) {
                return;
            }
            if (this.isSkillReady(p)) {
                this.useSkill(p);
                double damage = info.getAbilityScaling(FireMageInferno.class);
                event.setDamage(event.getDamage() + (damage += (double)(event.getEntity().getFireTicks() / 20)));
                Skills.get();
                p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_FireMage_Activation_Message));
                p.getWorld().playEffect(event.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.REDSTONE_BLOCK);
                p.getWorld().playEffect(event.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.REDSTONE_BLOCK);
            }
        }
    }
}

