/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;

public class FireMageBlackFire
extends Ability {
    public FireMageBlackFire() {
        this.isPassive = false;
        this.saveIndex = 18;
        this.langTitle = LanguageSupport.Languages.Skill_FireMage_BlackFire_Title;
        this.langDesc = LanguageSupport.Languages.Skill_FireMage_BlackFire;
        this.scaling = SkillsConfig.ConfigOption.SCALING_FIREMAGE_BLACKFIRE.getString();
        this.costScaling = SkillsConfig.ConfigOption.FIREMAGE_BLACKFIRE_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("firemage");
    }

    @EventHandler
    public void onFireDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FIRE_TICK && event.getCause() != EntityDamageEvent.DamageCause.FIRE) {
            return;
        }
        if (!event.isCancelled()) {
            for (Entity e : event.getEntity().getNearbyEntities(5.0, 5.0, 5.0)) {
                if (!(e instanceof Player)) continue;
                Player p = (Player)e;
                if (ExternalHandler.isCitizen((Entity)p)) {
                    return;
                }
                PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
                if (info.isDisabled(this)) {
                    return;
                }
                Ability[] abilityArray = info.getSkill().getAbilities();
                int n = abilityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Ability ab = abilityArray[n2];
                    if (ab instanceof FireMageBlackFire) {
                        if (info.getSkillImprovementLevel(ab) == 0) {
                            return;
                        }
                        double chance = ab.getScaling(info);
                        event.setDamage(event.getDamage() + chance);
                        p.getWorld().playEffect(event.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.COAL_BLOCK);
                    }
                    ++n2;
                }
            }
        }
    }
}

