/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import java.util.ArrayList;
import java.util.UUID;
import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class FireMageAbsorbEnergy
extends Ability {
    public ArrayList<UUID> absorbed = new ArrayList();

    public FireMageAbsorbEnergy() {
        this.isPassive = false;
        this.saveIndex = 16;
        this.langTitle = LanguageSupport.Languages.Skill_FireMage_AbsorbEnergy_Title;
        this.langDesc = LanguageSupport.Languages.Skill_FireMage_AbsorbEnergy;
        this.scaling = SkillsConfig.ConfigOption.SCALING_FIREMAGE_ABSORBENERGY.getString();
        this.costScaling = SkillsConfig.ConfigOption.FIREMAGE_ABSORBENERGY_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("firemage");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onFireMageAttack(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
            return;
        }
        Player p = (Player)event.getDamager();
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        if (info.isDisabled(this)) {
            return;
        }
        Ability[] abilityArray = info.getSkill().getAbilities();
        int n = abilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ability ab = abilityArray[n2];
            if (ab instanceof FireMageAbsorbEnergy) {
                if (info.getSkillImprovementLevel(ab) == 0) {
                    return;
                }
                if (this.absorbed.contains(p.getUniqueId())) {
                    this.absorbed.remove(p.getUniqueId());
                    int chance = (int)(ab.getScaling(info) * 20.0);
                    if (event.getEntity().getFireTicks() < chance * 20) {
                        event.getEntity().setFireTicks(event.getEntity().getFireTicks() + chance);
                    }
                }
            }
            ++n2;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onFireMageDefend(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            Player p = (Player)event.getEntity();
            if (p.getItemInHand() == null) {
                return;
            }
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof FireMageAbsorbEnergy) {
                    if (info.getSkillImprovementLevel(ab) == 0) {
                        return;
                    }
                    if (this.absorbed.contains(p.getUniqueId())) break;
                    this.absorbed.add(p.getUniqueId());
                    break;
                }
                ++n2;
            }
        }
    }
}

