/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.Cooldown;
import me.leothepro555.skills.utils.LoreUtil;
import me.leothepro555.skills.utils.XMaterial;
import me.leothepro555.skilltype.EidolonForm;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EidolonSpectre
extends Ability {
    public HashMap<UUID, Integer> prepped = new HashMap();

    public EidolonSpectre() {
        this.isPassive = false;
        this.saveIndex = 37;
        this.langTitle = LanguageSupport.Languages.Skill_Eidolon_Spectre_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Eidolon_Spectre;
        this.scaling = SkillsConfig.ConfigOption.SCALING_EIDOLON_SPECTRE_COOLDOWNS.getString();
        this.costScaling = SkillsConfig.ConfigOption.EIDOLON_SPECTRE_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("eidolon");
    }

    @EventHandler
    public void onEidolonAttack(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!(event.getEntity() instanceof Damageable)) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getDamager();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof EidolonSpectre) {
                    if (info.getSkillImprovementLevel(ab) == 0) {
                        return;
                    }
                    if (Cooldown.isInCooldown(p.getUniqueId(), "EShield") || info.getForm() != EidolonForm.DARK) break;
                    int time = (int)ab.getScaling(info);
                    double attack = info.getAbilityScaling(SkillsConfig.ConfigOption.SCALING_EIDOLON_SPECTRE_DARKATTACK.getString(), ab);
                    double multiplier = 1.0 + attack / 100.0;
                    event.setDamage(event.getDamage() * multiplier);
                    Skills.get();
                    p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Eidolon_Attack_Boost).replaceAll("%damage%", "" + attack));
                    Cooldown c = new Cooldown(p.getUniqueId(), "EShield", time);
                    c.start();
                    break;
                }
                ++n2;
            }
        }
    }

    @EventHandler
    public void onEidolonDefend(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            Player p = (Player)event.getEntity();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof EidolonSpectre) {
                    if (info.getSkillImprovementLevel(ab) == 0) {
                        return;
                    }
                    if (Cooldown.isInCooldown(p.getUniqueId(), "EShield") || info.getForm() != EidolonForm.LIGHT) break;
                    int time = (int)ab.getScaling(info);
                    int speed = (int)info.getAbilityScaling(SkillsConfig.ConfigOption.SCALING_EIDOLON_SPECTRE_SPEED.getString(), ab);
                    if (speed < 0) {
                        speed = 0;
                    }
                    if (speed > 3) {
                        speed = 3;
                    }
                    p.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 60, speed));
                    Skills.get();
                    p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Eidolon_Shield_Speed));
                    Cooldown c = new Cooldown(p.getUniqueId(), "EShield", time);
                    c.start();
                    break;
                }
                ++n2;
            }
        }
    }

    @Override
    public ItemStack getDescriptiveItem(PlayerInfo info) {
        ItemStack item = new ItemStack(XMaterial.FIREWORK_STAR.parseMaterial());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Skills.getLang().parseFirstString(this.langTitle));
        ArrayList<String> lore = new ArrayList<String>();
        int level = info.getSkillImprovementLevel(this);
        int time = (int)info.getAbilityScaling(EidolonSpectre.class);
        int speed = (int)info.getAbilityScaling(SkillsConfig.ConfigOption.SCALING_EIDOLON_SPECTRE_SPEED.getString(), this);
        if (speed < 0) {
            speed = 0;
        }
        if (speed > 3) {
            speed = 3;
        }
        String desc = Skills.getLang().parseFirstString(this.langDesc).replaceAll("%amount%", "" + this.getColourForString(SkillsConfig.ConfigOption.SCALING_EIDOLON_SPECTRE_SPEED.getString()) + (speed + 1)).replaceAll("%time%", "" + this.getColourForString(this.scaling) + time).replaceAll("%attack%", "" + this.getColourForString(SkillsConfig.ConfigOption.SCALING_EIDOLON_SPECTRE_DARKATTACK.getString()) + (int)info.getAbilityScaling(SkillsConfig.ConfigOption.SCALING_EIDOLON_SPECTRE_DARKATTACK.getString(), this));
        lore = LoreUtil.addLore(desc, lore, ChatColor.AQUA);
        if (!this.isPassive) {
            if (level < 3) {
                int cost = this.getSoulCost(level);
                Skills.get();
                lore = LoreUtil.addLore(String.valueOf(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Improve_Cost)) + cost, lore, ChatColor.RED);
            }
            lore = LoreUtil.addLore(ChatColor.AQUA + "LvL: " + ChatColor.YELLOW + level + "/3", lore, ChatColor.AQUA);
        }
        if (this.isPassive || level >= 3) {
            if (!info.isDisabled(this)) {
                Skills.get();
                lore = LoreUtil.addLore(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Disable_Ability), lore, ChatColor.RED);
            } else if (info.isDisabled(this)) {
                Skills.get();
                lore = LoreUtil.addLore(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Enable_Ability), lore, ChatColor.GREEN);
            }
        }
        String scales = Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Skill_Affected_By);
        String append = "";
        String scaling = String.valueOf(this.scaling) + SkillsConfig.ConfigOption.SCALING_EIDOLON_SPECTRE_DARKATTACK.getString() + SkillsConfig.ConfigOption.SCALING_EIDOLON_SPECTRE_SPEED.getString();
        if (scaling.contains("str")) {
            append = String.valueOf(append) + ChatColor.GOLD + "STR ";
        }
        if (scaling.contains("int")) {
            append = String.valueOf(append) + ChatColor.BLUE + "INT ";
        }
        if (scaling.contains("dex")) {
            append = String.valueOf(append) + ChatColor.LIGHT_PURPLE + "DEX";
        }
        if (scaling.contains("def")) {
            append = String.valueOf(append) + ChatColor.RED + "DEF ";
        }
        if (!append.equals("")) {
            scales = scales.replaceAll("%stat%", append);
            lore = LoreUtil.addLore(scales, lore, ChatColor.AQUA);
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }
}

