/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.events.EidolonImbalanceChangeEvent;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.HealthUtils;
import me.leothepro555.skilltype.EidolonForm;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;

public class EidolonPassive
extends Ability {
    public EidolonPassive() {
        this.isPassive = true;
        this.saveIndex = 35;
        this.langTitle = LanguageSupport.Languages.Skill_Passive_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Eidolon_Passive;
        this.scaling = SkillsConfig.ConfigOption.SCALING_EIDOLON_PASSIVE.getString();
        this.costScaling = "0";
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("eidolon");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEidolonChangeForm(EidolonImbalanceChangeEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getPlayer().getWorld().getName())) {
            return;
        }
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)event.getPlayer());
        if (info.isDisabled(this)) {
            return;
        }
        HealthUtils.healPlayer(event.getPlayer(), info.getAbilityScaling(EidolonPassive.class));
        if (event.getNewForm() == EidolonForm.LIGHT) {
            Player player = event.getPlayer();
            Skills.get();
            player.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Eidolon_Turn_Light));
        } else {
            Player player = event.getPlayer();
            Skills.get();
            player.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Eidolon_Turn_Dark));
        }
    }
}

