/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import me.leothepro555.skills.abilities.ActiveAbility;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.Cooldown;
import me.leothepro555.skills.utils.LoreUtil;
import me.leothepro555.skills.utils.XMaterial;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class EidolonDefile
extends ActiveAbility {
    public HashMap<UUID, Integer> imbalanced = new HashMap();

    public EidolonDefile() {
        this.isPassive = false;
        this.saveIndex = 39;
        this.langTitle = LanguageSupport.Languages.Skill_Eidolon_Defile_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Eidolon_Defile;
        this.scaling = SkillsConfig.ConfigOption.SCALING_EIDOLON_DEFILE.getString();
        this.abilityReady = LanguageSupport.Languages.Skill_Eidolon_Active_Ready;
        this.abilityIdle = LanguageSupport.Languages.Skill_Eidolon_Active_Not_Ready;
        this.abilityActivate = LanguageSupport.Languages.Skill_Eidolon_Active_Activation_Message;
        this.abilityFinished = null;
        this.energyCost = SkillsConfig.ConfigOption.EIDOLON_DEFILE_ENERGY_COST.getInt();
        this.cooldown = SkillsConfig.ConfigOption.EIDOLON_DEFILE_COOLDOWN.getInt();
        this.costScaling = SkillsConfig.ConfigOption.EIDOLON_DEFILE_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("eidolon");
    }

    @EventHandler
    public void onEidolonAttack(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getDamager();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            if (!info.getSkill().getConfigName().equals(this.getType().getConfigName())) {
                return;
            }
            if (event.isCancelled()) {
                return;
            }
            if (this.isSkillReady(p)) {
                this.useSkill(p);
                if (!(event.getEntity() instanceof Damageable)) {
                    return;
                }
                int amt = (int)info.getAbilityScaling(EidolonDefile.class);
                this.imbalanced.put(event.getEntity().getUniqueId(), amt);
                int time = (int)info.getAbilityScaling(SkillsConfig.ConfigOption.SCALING_EIDOLON_DEFILE_TIME.getString(), this);
                if (time <= 0) {
                    time = 2;
                }
                Cooldown timer = new Cooldown(event.getEntity().getUniqueId(), "eidolondefiled", time);
                timer.start();
                event.setDamage(event.getDamage() * (double)(1.0f + (float)this.imbalanced.get(event.getEntity().getUniqueId()).intValue() / 100.0f));
                event.getEntity().getWorld().playEffect(event.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.LAPIS_BLOCK);
                event.getEntity().getWorld().playEffect(event.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.COAL_BLOCK);
                event.getEntity().getWorld().playEffect(event.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.IRON_BLOCK);
            }
        }
    }

    @EventHandler
    public void onDamageReceive(EntityDamageEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (this.imbalanced.containsKey(event.getEntity().getUniqueId())) {
            if (Cooldown.isInCooldown(event.getEntity().getUniqueId(), "eidolondefiled")) {
                event.setDamage(event.getDamage() * (double)(1.0f + (float)this.imbalanced.get(event.getEntity().getUniqueId()).intValue() / 100.0f));
                event.getEntity().getWorld().playEffect(event.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.LAPIS_BLOCK);
                event.getEntity().getWorld().playEffect(event.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.COAL_BLOCK);
                event.getEntity().getWorld().playEffect(event.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.IRON_BLOCK);
            } else {
                this.imbalanced.remove(event.getEntity().getUniqueId());
            }
        }
    }

    @Override
    public ItemStack getDescriptiveItem(PlayerInfo info) {
        ItemStack item = new ItemStack(XMaterial.FIREWORK_STAR.parseMaterial());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Skills.getLang().parseFirstString(this.langTitle));
        ArrayList<String> lore = new ArrayList<String>();
        int level = info.getSkillImprovementLevel(this);
        ChatColor color = ChatColor.WHITE;
        if (this.scaling.contains("str")) {
            color = ChatColor.GOLD;
        } else if (this.scaling.contains("int")) {
            color = ChatColor.BLUE;
        } else if (this.scaling.contains("dex")) {
            color = ChatColor.LIGHT_PURPLE;
        } else if (this.scaling.contains("def")) {
            color = ChatColor.RED;
        }
        String desc = Skills.getLang().parseFirstString(this.langDesc).replaceAll("%amount%", "" + color + this.getScaling(info)).replaceAll("%time%", "" + color + info.getAbilityScaling(SkillsConfig.ConfigOption.SCALING_EIDOLON_DEFILE_TIME.getString(), this));
        lore = LoreUtil.addLore(desc, lore, ChatColor.AQUA);
        if (!this.isPassive) {
            if (level < 3) {
                int cost = this.getSoulCost(level);
                Skills.get();
                lore = LoreUtil.addLore(String.valueOf(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Improve_Cost)) + cost, lore, ChatColor.RED);
            }
            lore = LoreUtil.addLore(ChatColor.AQUA + "LvL: " + ChatColor.YELLOW + level + "/3", lore, ChatColor.AQUA);
        }
        if (this.isPassive || level >= 3) {
            if (!info.isDisabled(this)) {
                Skills.get();
                lore = LoreUtil.addLore(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Disable_Ability), lore, ChatColor.RED);
            } else if (info.isDisabled(this)) {
                Skills.get();
                lore = LoreUtil.addLore(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Enable_Ability), lore, ChatColor.GREEN);
            }
        }
        String scales = Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Skill_Affected_By);
        String append = "";
        String scaling = String.valueOf(this.scaling) + SkillsConfig.ConfigOption.SCALING_EIDOLON_DEFILE_TIME.getString();
        if (scaling.contains("str")) {
            append = String.valueOf(append) + ChatColor.GOLD + "STR ";
        } else if (scaling.contains("int")) {
            append = String.valueOf(append) + ChatColor.BLUE + "INT ";
        } else if (scaling.contains("dex")) {
            append = String.valueOf(append) + ChatColor.LIGHT_PURPLE + "DEX";
        } else if (scaling.contains("def")) {
            append = String.valueOf(append) + ChatColor.RED + "DEF ";
        }
        if (!append.equals("")) {
            scales = scales.replaceAll("%stat%", append);
            lore = LoreUtil.addLore(scales, lore, ChatColor.AQUA);
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }
}

