/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.damage.CustomPoisonor;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class DevourerPassive
extends Ability {
    public DevourerPassive() {
        this.isPassive = true;
        this.saveIndex = 5;
        this.langTitle = LanguageSupport.Languages.Skill_Passive_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Devourer_Passive;
        this.scaling = SkillsConfig.ConfigOption.SCALING_DEVOURER_PASSIVE.getString();
        this.costScaling = "0";
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("devourer");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDevourerAttack(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getDamager();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (info.isDisabled(this)) {
                    return;
                }
                if (ab instanceof DevourerPassive) {
                    if (CustomPoisonor.victimlist.containsKey(event.getEntity().getUniqueId())) break;
                    CustomPoisonor customPoisonor = new CustomPoisonor(p, (LivingEntity)event.getEntity(), (int)this.getScaling(info), 5);
                    break;
                }
                ++n2;
            }
        }
    }
}

