/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.HealthUtils;
import me.leothepro555.skills.utils.MathUtil;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class DevourerEvolveSadism
extends Ability {
    public DevourerEvolveSadism() {
        this.isPassive = false;
        this.saveIndex = 8;
        this.langTitle = LanguageSupport.Languages.Skill_Devourer_EvolveSadism_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Devourer_EvolveSadism;
        this.scaling = SkillsConfig.ConfigOption.SCALING_DEVOURER_EVOLVESADISM.getString();
        this.costScaling = SkillsConfig.ConfigOption.DEVOURER_EVOLVESADISM_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("devourer");
    }

    @EventHandler
    public void onDevourerAttack(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
                return;
            }
            Player p = (Player)event.getDamager();
            if (p.getItemInHand() == null) {
                return;
            }
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof DevourerEvolveSadism) {
                    if (info.isDisabled(this)) {
                        return;
                    }
                    if (info.getSkillImprovementLevel(ab) <= 0) {
                        return;
                    }
                    if (!(event.getEntity() instanceof LivingEntity)) break;
                    double chance = ab.getScaling(info);
                    if (!((double)MathUtil.randInt(0, 100) <= chance)) break;
                    HealthUtils.healPlayer(p, 1.0);
                    break;
                }
                ++n2;
            }
        }
    }
}

