/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.PotionUtils;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.potion.PotionEffectType;

public class DevourerEvolveGliders
extends Ability {
    public DevourerEvolveGliders() {
        this.isPassive = false;
        this.saveIndex = 6;
        this.langTitle = LanguageSupport.Languages.Skill_Devourer_EvolveGliders_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Devourer_EvolveGliders;
        this.scaling = SkillsConfig.ConfigOption.SCALING_DEVOURER_EVOLVEGLIDERS.getString();
        this.costScaling = SkillsConfig.ConfigOption.DEVOURER_EVOLVEGLIDERS_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("devourer");
    }

    @EventHandler
    public void onSprint(PlayerMoveEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getPlayer().getWorld().getName())) {
            return;
        }
        Player p = event.getPlayer();
        if (ExternalHandler.isCitizen((Entity)p)) {
            return;
        }
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        Ability[] abilityArray = info.getSkill().getAbilities();
        int n = abilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ability ab = abilityArray[n2];
            if (ab instanceof DevourerEvolveGliders) {
                if (info.isDisabled(this)) {
                    return;
                }
                if (!p.isSprinting()) break;
                if (info.getSkillImprovementLevel(ab) == 0) {
                    return;
                }
                int potency = (int)ab.getScaling(info) - 1;
                if (potency < 0) {
                    return;
                }
                PotionUtils.addProlongedPotionEffect(p, PotionEffectType.SPEED, potency);
                break;
            }
            ++n2;
        }
    }
}

