/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import java.util.List;
import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.events.SkillToggleDisableEvent;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.Cooldown;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DevourerEvolveCloak
extends Ability {
    public DevourerEvolveCloak() {
        this.isPassive = false;
        this.saveIndex = 7;
        this.langTitle = LanguageSupport.Languages.Skill_Devourer_EvolveCloak_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Devourer_EvolveCloak;
        this.scaling = SkillsConfig.ConfigOption.SCALING_DEVOURER_EVOLVECLOAK.getString();
        this.costScaling = SkillsConfig.ConfigOption.DEVOURER_EVOLVECLOAK_COST.getString();
        Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)Skills.get(), new Runnable(){

            @Override
            public void run() {
                List worlds = Bukkit.getWorlds();
                if (Skills.get().getPlayerDataManager() == null) {
                    return;
                }
                for (World w : worlds) {
                    for (final Player online : w.getPlayers()) {
                        int level;
                        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(online.getWorld().getName())) continue;
                        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)online);
                        if (info.isDisabled(DevourerEvolveCloak.this)) {
                            return;
                        }
                        if (!info.getSkill().getConfigName().equals(DevourerEvolveCloak.this.getType().getConfigName()) || (level = info.getSkillImprovementLevel(DevourerEvolveCloak.class)) <= 0 || Cooldown.isInCooldown(online.getUniqueId(), "devourerinvis")) continue;
                        Bukkit.getScheduler().runTask((Plugin)Skills.get(), new Runnable(){

                            @Override
                            public void run() {
                                DevourerEvolveCloak.activateInvisibility(online);
                            }
                        });
                    }
                }
            }
        }, 0L, 100L);
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("devourer");
    }

    @EventHandler
    public void onDevourerAttack(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
            return;
        }
        final Player p = (Player)event.getDamager();
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        if (!info.getSkill().getConfigName().equals(this.getType().getConfigName())) {
            return;
        }
        final int level = info.getSkillImprovementLevel(DevourerEvolveCloak.class);
        if (level <= 0) {
            return;
        }
        if (p.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            if (p.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                Skills.get();
                p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Devourer_Invis_Disabled));
                if (level > 2) {
                    event.setDamage(event.getDamage() + info.getAbilityScaling(DevourerEvolveCloak.class));
                }
            }
            p.removePotionEffect(PotionEffectType.INVISIBILITY);
            Cooldown c = new Cooldown(p.getUniqueId(), "devourerinvis", 30);
            c.start();
            if (level > 1) {
                if (!Cooldown.isInCooldown(p.getUniqueId(), "devourerneutral")) {
                    Skills.get();
                    p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Devourer_Neutrality_Disabled));
                }
                Cooldown cd = new Cooldown(p.getUniqueId(), "devourerneutral", 30);
                cd.start();
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skills.get(), new Runnable(){

                @Override
                public void run() {
                    if (!Cooldown.isInCooldown(p.getUniqueId(), "devourerinvis")) {
                        DevourerEvolveCloak.activateInvisibility(p);
                    }
                    if (!Cooldown.isInCooldown(p.getUniqueId(), "devourerneutral") && level > 1) {
                        Skills.get();
                        p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Devourer_Neutrality_Enabled));
                    }
                }
            }, 600L);
        }
    }

    @EventHandler
    public void onSkillToggleDisabled(SkillToggleDisableEvent event) {
        OfflinePlayer op;
        if (event.getToggled() instanceof DevourerEvolveCloak && event.isDisabled() && (op = event.getPlayer()).isOnline()) {
            ((Player)op).removePotionEffect(PotionEffectType.INVISIBILITY);
        }
    }

    @EventHandler
    public void onBowUse(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        Skills plugin = Skills.get();
        if (!(event.getDamager() instanceof Projectile)) {
            return;
        }
        Projectile proj = (Projectile)event.getDamager();
        if (proj.getShooter() == null) {
            return;
        }
        if (!(proj.getShooter() instanceof Player)) {
            return;
        }
        if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
            return;
        }
        final Player p = (Player)proj.getShooter();
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        if (!info.getSkill().getConfigName().equals(this.getType().getConfigName())) {
            return;
        }
        final int level = info.getSkillImprovementLevel(DevourerEvolveCloak.class);
        if (level > 0 && p.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            if (p.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                Skills.get();
                p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Devourer_Invis_Disabled));
                if (level > 2) {
                    event.setDamage(event.getDamage() + info.getAbilityScaling(DevourerEvolveCloak.class));
                }
            }
            p.removePotionEffect(PotionEffectType.INVISIBILITY);
            Cooldown c = new Cooldown(p.getUniqueId(), "devourerinvis", 30);
            c.start();
            if (level > 1) {
                if (!Cooldown.isInCooldown(p.getUniqueId(), "devourerneutral")) {
                    Skills.get();
                    p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Devourer_Neutrality_Disabled));
                }
                Cooldown cd = new Cooldown(p.getUniqueId(), "devourerneutral", 30);
                cd.start();
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skills.get(), new Runnable(){

                @Override
                public void run() {
                    if (!Cooldown.isInCooldown(p.getUniqueId(), "devourerinvis")) {
                        DevourerEvolveCloak.activateInvisibility(p);
                    }
                    if (!Cooldown.isInCooldown(p.getUniqueId(), "devourerneutral") && level > 1) {
                        Skills.get();
                        p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Devourer_Neutrality_Enabled));
                    }
                }
            }, 600L);
        }
    }

    @EventHandler
    public void onTarget(EntityTargetEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getTarget() instanceof Player) {
            Player p = (Player)event.getTarget();
            if (ExternalHandler.isCitizen((Entity)p)) {
                return;
            }
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            int level = info.getSkillImprovementLevel(DevourerEvolveCloak.class);
            if (info.getSkill().getConfigName().equals(this.getType().getConfigName()) && level > 1 && !Cooldown.isInCooldown(p.getUniqueId(), "devourerneutral")) {
                event.setCancelled(true);
            }
        }
    }

    public static void activateInvisibility(Player p) {
        if (!p.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            Skills.get();
            p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Devourer_Invis_Enabled));
        }
        p.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 200, 1), true);
    }
}

