/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import java.util.HashMap;
import java.util.UUID;
import me.leothepro555.skills.abilities.ActiveAbility;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.HealthUtils;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class DevourerConsume
extends ActiveAbility {
    public HashMap<UUID, Integer> activeTrapcount = new HashMap();
    public HashMap<UUID, Location> activeLocation = new HashMap();
    public HashMap<UUID, LivingEntity> thousandcuts = new HashMap();

    public DevourerConsume() {
        this.isPassive = false;
        this.saveIndex = 9;
        this.langTitle = LanguageSupport.Languages.Skill_Devourer_Consume_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Devourer_Consume;
        this.scaling = SkillsConfig.ConfigOption.SCALING_DEVOURER_CONSUME.getString();
        this.abilityReady = LanguageSupport.Languages.Skill_Devourer_Ready_Activation_Message;
        this.abilityIdle = LanguageSupport.Languages.Skill_Devourer_NotReady_Activation_Message;
        this.abilityActivate = LanguageSupport.Languages.Skill_Devourer_Activation_Message;
        this.abilityFinished = null;
        this.energyCost = SkillsConfig.ConfigOption.DEVOURER_CONSUME_ENERGY_COST.getInt();
        this.cooldown = SkillsConfig.ConfigOption.DEVOURER_CONSUME_COOLDOWN.getInt();
        this.costScaling = SkillsConfig.ConfigOption.DEVOURER_CONSUME_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("devourer");
    }

    @EventHandler
    public void onDevourerAttack(final EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            final Player p = (Player)event.getDamager();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            if (!info.getSkill().getConfigName().equals(this.getType().getConfigName())) {
                return;
            }
            if (event.isCancelled()) {
                return;
            }
            if (this.isSkillReady(p)) {
                this.useSkill(p);
                if (!(event.getEntity() instanceof Damageable)) {
                    return;
                }
                double maxhealth = ((Damageable)event.getEntity()).getMaxHealth();
                double currhealth = ((Damageable)event.getEntity()).getHealth();
                String bonusString = SkillsConfig.ConfigOption.SCALING_DEVOURER_CONSUME_HEALTH_BONUS.getString().replaceAll("victimhp", String.valueOf(currhealth)).replaceAll("victimmaxhp", String.valueOf(maxhealth));
                double extraDamage = info.getAbilityScaling(bonusString, this);
                double damage = info.getAbilityScaling(DevourerConsume.class) + extraDamage;
                event.setDamage(event.getDamage() + damage);
                Skills.get();
                p.sendMessage(Skills.getLang().parseFirstString(this.abilityActivate));
                p.getWorld().playEffect(event.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.REDSTONE_BLOCK);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skills.get(), new Runnable(){

                    @Override
                    public void run() {
                        if (event.getEntity().isDead()) {
                            double regainAmt = p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue() / 2.0;
                            HealthUtils.healPlayer(p, regainAmt);
                            Skills.get();
                            p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Skill_Devourer_Heal_Message).replaceAll("%amount%", "" + (int)regainAmt));
                        }
                    }
                }, 1L);
            }
        }
    }
}

