/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.ActiveAbility;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.events.CustomHudChangeEvent;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skilltype.ScalingType;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ArbalistFireCrossbow
extends ActiveAbility {
    public ArbalistFireCrossbow() {
        this.isPassive = false;
        this.saveIndex = 29;
        this.langTitle = LanguageSupport.Languages.Skill_Arbalist_FireCrossbow_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Arbalist_FireCrossBow;
        this.scaling = SkillsConfig.ConfigOption.SCALING_ARBALIST_FIRECROSSBOW.getString();
        this.abilityReady = LanguageSupport.Languages.Skill_Arbalist_Activation_Msg;
        this.abilityIdle = null;
        this.abilityActivate = null;
        this.abilityFinished = null;
        this.weaponType = "BOW";
        this.energyCost = SkillsConfig.ConfigOption.ARBALIST_FIRECROSSBOW_ENERGY_COST.getInt();
        this.cooldown = 1;
        this.click = ActiveAbility.ClickType.LEFT_CLICK;
        this.activateOnReady = true;
        this.costScaling = SkillsConfig.ConfigOption.ARBALIST_FIRECROSSBOW_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("arbalist");
    }

    @Override
    protected void useSkill(Player p) {
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        if (info.isDisabled(this)) {
            return;
        }
        info.setActiveReady(false);
        double curr = info.getActiveStatType(ScalingType.ENERGY);
        info.setActiveStatType(ScalingType.ENERGY, curr - (double)this.energyCost);
        int arrowcd = (int)info.getAbilityScaling(ArbalistFireCrossbow.class);
        info.setActiveStatType(ScalingType.ACTIVECD, arrowcd);
        CustomHudChangeEvent hudevent = new CustomHudChangeEvent(p);
        Bukkit.getPluginManager().callEvent((Event)hudevent);
        double pitch = (double)(p.getLocation().getPitch() + 90.0f) * Math.PI / 180.0;
        double yaw = (double)(p.getLocation().getYaw() + 90.0f) * Math.PI / 180.0;
        double x = Math.sin(pitch) * Math.cos(yaw);
        double y = Math.sin(pitch) * Math.sin(yaw);
        double z = Math.cos(pitch);
        Vector vector = new Vector(x, z, y);
        Arrow arrow = (Arrow)p.launchProjectile(Arrow.class);
        arrow.setVelocity(vector);
        arrow.setMetadata("no_pickup", (MetadataValue)new FixedMetadataValue((Plugin)Skills.get(), (Object)"yes!"));
    }

    @EventHandler
    public void onProjectileLand(ProjectileHitEvent event) {
        if (event.getHitBlock() != null && event.getEntity().hasMetadata("no_pickup")) {
            event.getEntity().remove();
        }
    }

    @EventHandler
    public void onPlayerPickupItem(PlayerPickupArrowEvent event) {
        if (event.getItem().hasMetadata("no_pickup")) {
            event.setCancelled(true);
        }
    }
}

