/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import java.util.HashMap;
import java.util.UUID;
import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class ArbalistDualArrows
extends Ability {
    public HashMap<UUID, Integer> execute = new HashMap();
    public HashMap<UUID, Integer> dualarrows = new HashMap();

    public ArbalistDualArrows() {
        this.isPassive = false;
        this.saveIndex = 27;
        this.langTitle = LanguageSupport.Languages.Skill_Arbalist_DualArrow_Title;
        this.langDesc = LanguageSupport.Languages.Skill_Arbalist_DualArrow;
        this.scaling = SkillsConfig.ConfigOption.SCALING_ARBALIST_DUALARROW.getString();
        this.costScaling = SkillsConfig.ConfigOption.ARBALIST_DUALARROW_COST.getString();
    }

    @Override
    public SkillType getType() {
        return Skills.get().getSkillTypeManager().getSkilltypes().get("arbalist");
    }

    @EventHandler
    public void onAttack(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (!ExternalHandler.canFight(event.getEntity(), event.getDamager())) {
            return;
        }
        Skills plugin = Skills.get();
        if (event.getDamager() instanceof Arrow && ((Arrow)event.getDamager()).getShooter() != null && ((Arrow)event.getDamager()).getShooter() instanceof Player) {
            Player p = (Player)((Arrow)event.getDamager()).getShooter();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (this.dualarrows.containsKey(event.getDamager().getUniqueId())) {
                if (this.dualarrows.get(event.getDamager().getUniqueId()) == 1) {
                    event.setDamage(event.getDamage() / 2.0);
                } else if (this.dualarrows.get(event.getDamager().getUniqueId()) == 2) {
                    event.setDamage(event.getDamage());
                } else if (this.dualarrows.get(event.getDamager().getUniqueId()) > 2) {
                    double chance = info.getAbilityScaling(ArbalistDualArrows.class);
                    event.setDamage(event.getDamage() + chance);
                }
                Skills.logDebug("DUAL Arrow damage: " + event.getDamage());
            } else {
                Skills.logDebug("Arrow damage: " + event.getDamage());
            }
        }
    }

    @EventHandler
    public void onArrowLaunch(ProjectileLaunchEvent event) {
        if (this.dualarrows.containsKey(event.getEntity().getUniqueId())) {
            return;
        }
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!(event.getEntity() instanceof Arrow)) {
            return;
        }
        if (event.getEntity().getShooter() != null && event.getEntity().getShooter() instanceof Player) {
            Player p = (Player)event.getEntity().getShooter();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            Ability[] abilityArray = info.getSkill().getAbilities();
            int n = abilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ability ab = abilityArray[n2];
                if (ab instanceof ArbalistDualArrows) {
                    Vector avec;
                    if (info.isDisabled(ab)) {
                        return;
                    }
                    if (info.getSkillImprovementLevel(ab) == 0) {
                        return;
                    }
                    Vector vec = avec = event.getEntity().getVelocity();
                    Arrow arrow = (Arrow)p.getWorld().spawn(p.getEyeLocation(), Arrow.class);
                    arrow.setShooter((ProjectileSource)p);
                    arrow.setVelocity(vec);
                    this.dualarrows.put(arrow.getUniqueId(), info.getSkillImprovementLevel(ab));
                    break;
                }
                ++n2;
            }
        }
    }
}

