/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.events.CustomHudChangeEvent;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.XMaterial;
import me.leothepro555.skilltype.ScalingType;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class ActiveAbility
extends Ability {
    protected LanguageSupport.Languages abilityReady;
    protected LanguageSupport.Languages abilityIdle;
    protected LanguageSupport.Languages abilityActivate;
    protected LanguageSupport.Languages abilityFinished;
    protected LanguageSupport.Languages abilityNeedMoreEnergy = LanguageSupport.Languages.Misc_Not_enough_Energy;
    protected int energyCost;
    protected int cooldown;
    protected String weaponType;
    public boolean activateOnReady = false;
    protected boolean sneakRequired = false;
    protected ClickType click = ClickType.RIGHT_CLICK;

    protected boolean isSkillReady(Player p) {
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        return info.isActiveReady();
    }

    protected void useSkill(Player p) {
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        double curr = info.getActiveStatType(ScalingType.ENERGY);
        info.setActiveStatType(ScalingType.ENERGY, curr - (double)this.energyCost);
        info.setActiveReady(false);
        if (this.abilityActivate != null) {
            Skills.get();
            p.sendMessage(Skills.getLang().parseFirstString(this.abilityActivate));
        }
        info.setActiveStatType(ScalingType.ACTIVECD, this.cooldown);
        CustomHudChangeEvent hudevent = new CustomHudChangeEvent(p);
        Bukkit.getPluginManager().callEvent((Event)hudevent);
    }

    @EventHandler
    public void onSkillActivate(PlayerInteractEvent event) {
        if (this.sneakRequired && !event.getPlayer().isSneaking()) {
            return;
        }
        boolean isInBlacklist = false;
        if (event.getPlayer().getItemInHand() != null) {
            if ((event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_AIR) && event.getPlayer().getItemInHand().getType().isEdible()) {
                return;
            }
            for (String type : SkillsConfig.ConfigOption.ITEMS_THAT_PREVENT_SKILLACTIVATION.getStringList()) {
                ItemStack subject;
                XMaterial mat = XMaterial.fromString(type);
                if (mat == null || !mat.isSameMaterial(subject = event.getPlayer().getItemInHand())) continue;
                isInBlacklist = true;
                break;
            }
        }
        if ((event.getAction() == Action.LEFT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_BLOCK) && event.getPlayer().getItemInHand() != null) {
            if (event.getPlayer().getItemInHand().getType().isBlock() && !event.isCancelled()) {
                return;
            }
            if (isInBlacklist) {
                return;
            }
        }
        if (SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getPlayer().getWorld().getName())) {
            final Player p = event.getPlayer();
            final PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.isDisabled(this)) {
                return;
            }
            if (!info.getSkill().getConfigName().equals(this.getType().getConfigName())) {
                return;
            }
            if (!(this.weaponType == null || p.getItemInHand() != null && p.getItemInHand().getType().toString().contains(this.weaponType))) {
                return;
            }
            if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK && this.click == ClickType.RIGHT_CLICK) {
                return;
            }
            if (event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK && this.click == ClickType.LEFT_CLICK) {
                return;
            }
            if (info.getActiveStatType(ScalingType.ENERGY) < (double)this.energyCost) {
                if (info.showReadyMessages()) {
                    Skills.get();
                    p.sendMessage(Skills.getLang().parseFirstString(this.abilityNeedMoreEnergy).replaceAll("%amount%", "" + this.energyCost));
                }
                return;
            }
            if (info.isActiveReady()) {
                return;
            }
            if (info.getActiveStatType(ScalingType.ACTIVECD) <= 0.0) {
                info.setActiveReady(true);
                if (info.showReadyMessages() && this.abilityReady != null) {
                    Skills.get();
                    p.sendMessage(Skills.getLang().parseFirstString(this.abilityReady));
                }
                if (this.activateOnReady) {
                    this.useSkill(p);
                    return;
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skills.get(), new Runnable(){

                    @Override
                    public void run() {
                        if (info.isActiveReady()) {
                            info.setActiveReady(false);
                            if (info.showReadyMessages() && ActiveAbility.this.abilityIdle != null) {
                                Skills.get();
                                p.sendMessage(Skills.getLang().parseFirstString(ActiveAbility.this.abilityIdle));
                            }
                        }
                    }
                }, 60L);
            }
        }
    }

    private String getCDName() {
        return String.valueOf(this.getType().getConfigName()) + "activecd";
    }

    public static enum ClickType {
        RIGHT_CLICK,
        LEFT_CLICK;

    }
}

