/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.abilities;

import java.util.ArrayList;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.utils.LoreUtil;
import me.leothepro555.skills.utils.MathUtil;
import me.leothepro555.skills.utils.XMaterial;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.ChatColor;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class Ability
implements Listener {
    public int saveIndex;
    public LanguageSupport.Languages langTitle;
    public LanguageSupport.Languages langDesc;
    public String scaling;
    public boolean isPassive = false;
    public String costScaling;

    public double getScaling(PlayerInfo info) {
        String finalEquation = this.scaling.replaceAll("int", "" + info.getStatint()).replaceAll("str", "" + info.getStatstr()).replaceAll("def", "" + info.getStatdef()).replaceAll("dex", "" + info.getStatdex()).replaceAll("lvl", "" + info.getSkillImprovementLevel(this));
        return MathUtil.evaluateEquation(finalEquation);
    }

    public int getSoulCost(int level) {
        String finalEquation = this.costScaling.replaceAll("lvl", "" + level);
        return (int)MathUtil.evaluateEquation(finalEquation);
    }

    public abstract SkillType getType();

    public boolean equals(Object obj) {
        if (!(obj instanceof Ability)) {
            return false;
        }
        Ability ab = (Ability)obj;
        return this.saveIndex == ab.saveIndex && this.langTitle.equals((Object)ab.langTitle);
    }

    public ItemStack getDescriptiveItem(PlayerInfo info) {
        ItemStack item = new ItemStack(XMaterial.FIREWORK_STAR.parseMaterial());
        if (info.isDisabled(this)) {
            item = new ItemStack(XMaterial.BARRIER.parseMaterial());
        }
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Skills.getLang().parseFirstString(this.langTitle));
        ArrayList<String> lore = new ArrayList<String>();
        int level = info.getSkillImprovementLevel(this);
        ChatColor color = this.getColourForString(this.scaling);
        String desc = Skills.getLang().parseFirstString(this.langDesc).replaceAll("%amount%", "" + color + (int)this.getScaling(info)).replaceAll("%damage%", "" + color + (int)this.getScaling(info)).replaceAll("%chance%", "" + color + (int)this.getScaling(info)).replaceAll("%time%", "" + color + (int)this.getScaling(info)).replaceAll("%calculatedamt%", "" + color + (int)this.getScaling(info));
        lore = LoreUtil.addLore(desc, lore, ChatColor.AQUA);
        if (!this.isPassive) {
            if (level < 3) {
                int cost = this.getSoulCost(level);
                Skills.get();
                lore = LoreUtil.addLore(String.valueOf(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Improve_Cost)) + cost, lore, ChatColor.RED);
            }
            lore = LoreUtil.addLore(ChatColor.AQUA + "LvL: " + ChatColor.YELLOW + level + "/3", lore, ChatColor.AQUA);
        }
        if (this.isPassive || level >= 3) {
            if (!info.isDisabled(this)) {
                Skills.get();
                lore = LoreUtil.addLore(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Disable_Ability), lore, ChatColor.RED);
            } else if (info.isDisabled(this)) {
                Skills.get();
                lore = LoreUtil.addLore(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Enable_Ability), lore, ChatColor.GREEN);
            }
        }
        String scales = Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Skill_Affected_By);
        String append = "";
        if (this.scaling.contains("str")) {
            append = String.valueOf(append) + ChatColor.GOLD + "STR ";
        }
        if (this.scaling.contains("int")) {
            append = String.valueOf(append) + ChatColor.BLUE + "INT ";
        }
        if (this.scaling.contains("dex")) {
            append = String.valueOf(append) + ChatColor.LIGHT_PURPLE + "DEX";
        }
        if (this.scaling.contains("def")) {
            append = String.valueOf(append) + ChatColor.RED + "DEF ";
        }
        if (!append.equals("")) {
            scales = scales.replaceAll("%stat%", append);
            lore = LoreUtil.addLore(scales, lore, ChatColor.AQUA);
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    protected ChatColor getColourForString(String scaling) {
        ChatColor color = ChatColor.WHITE;
        if (scaling.contains("str")) {
            color = ChatColor.GOLD;
        } else if (scaling.contains("int")) {
            color = ChatColor.BLUE;
        } else if (scaling.contains("dex")) {
            color = ChatColor.LIGHT_PURPLE;
        } else if (scaling.contains("def")) {
            color = ChatColor.RED;
        }
        return color;
    }
}

