/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.xseries.particles;

import java.awt.Color;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.skills.utils.xseries.particles.XParticle;

public class ParticleDisplay
implements Cloneable {
    private static final boolean ISFLAT = XParticle.getParticle("FOOTSTEP") == null;
    private static final Particle DEFAULT_PARTICLE = Particle.CLOUD;
    @Nonnull
    public Particle particle;
    @Nullable
    public Location location;
    @Nullable
    public Callable<Location> locationCaller;
    public int count;
    public double offsetx;
    public double offsety;
    public double offsetz;
    public double extra;
    @Nullable
    public Vector rotation;
    @Nullable
    public Object data;

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Callable<Location> callable, @Nullable Location location, int n, double d, double d2, double d3, double d4) {
        this.particle = particle;
        this.location = location;
        this.locationCaller = callable;
        this.count = n;
        this.offsetx = d;
        this.offsety = d2;
        this.offsetz = d3;
        this.extra = d4;
    }

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Location location, int n, double d, double d2, double d3) {
        this(particle, null, location, n, d, d2, d3, 0.0);
    }

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Location location, int n) {
        this(particle, location, n, 0.0, 0.0, 0.0);
    }

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Location location) {
        this(particle, location, 0);
    }

    @Nonnull
    public static ParticleDisplay colored(@Nullable Location location, int n, int n2, int n3, float f) {
        ParticleDisplay particleDisplay = new ParticleDisplay(Particle.REDSTONE, null, location, 1, 0.0, 0.0, 0.0, 0.0);
        particleDisplay.data = new float[]{n, n2, n3, f};
        return particleDisplay;
    }

    @Nonnull
    public static ParticleDisplay colored(@Nullable Location location, @Nonnull Color color, float f) {
        return ParticleDisplay.colored(location, color.getRed(), color.getGreen(), color.getBlue(), f);
    }

    @Nonnull
    public static ParticleDisplay simple(@Nullable Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(particle, "Cannot build ParticleDisplay with null particle");
        return new ParticleDisplay(particle, null, location, 1, 0.0, 0.0, 0.0, 0.0);
    }

    @Nonnull
    public static ParticleDisplay display(@Nonnull Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(location, "Cannot display particle in null location");
        ParticleDisplay particleDisplay = ParticleDisplay.simple(location, particle);
        particleDisplay.spawn();
        return particleDisplay;
    }

    public static ParticleDisplay fromConfig(@Nullable Location location, @Nonnull ConfigurationSection configurationSection) {
        ParticleDisplay particleDisplay = new ParticleDisplay(DEFAULT_PARTICLE, location);
        return ParticleDisplay.edit(particleDisplay, configurationSection);
    }

    @Nonnull
    public static ParticleDisplay edit(@Nonnull ParticleDisplay particleDisplay, @Nonnull ConfigurationSection configurationSection) {
        String[] stringArray;
        String string;
        String[] stringArray2;
        String[] stringArray3;
        String string2;
        Objects.requireNonNull(particleDisplay, "Cannot edit a null particle display");
        Objects.requireNonNull(configurationSection, "Cannot parse ParticleDisplay from a null config section");
        String string3 = configurationSection.getString("particle");
        Particle particle = string3 == null ? null : XParticle.getParticle(string3);
        int n = configurationSection.getInt("count");
        double d = configurationSection.getDouble("extra");
        if (particle != null) {
            particleDisplay.particle = particle;
        }
        if (n != 0) {
            particleDisplay.withCount(n);
        }
        if (d != 0.0) {
            particleDisplay.extra = d;
        }
        if ((string2 = configurationSection.getString("offset")) != null && (stringArray3 = StringUtils.split((String)StringUtils.deleteWhitespace((String)string2), (char)',')).length >= 3) {
            double d2 = NumberUtils.toDouble((String)stringArray3[0]);
            double d3 = NumberUtils.toDouble((String)stringArray3[1]);
            double d4 = NumberUtils.toDouble((String)stringArray3[2]);
            particleDisplay.offset(d2, d3, d4);
        }
        if ((stringArray3 = configurationSection.getString("rotation")) != null && (stringArray2 = StringUtils.split((String)StringUtils.deleteWhitespace((String)stringArray3), (char)',')).length >= 3) {
            double d5 = NumberUtils.toDouble((String)stringArray2[0]);
            double d6 = NumberUtils.toDouble((String)stringArray2[1]);
            double d7 = NumberUtils.toDouble((String)stringArray2[2]);
            particleDisplay.rotation = new Vector(d5, d6, d7);
        }
        if ((string = configurationSection.getString("color")) != null && (stringArray = StringUtils.split((String)StringUtils.deleteWhitespace((String)string), (char)',')).length >= 3) {
            particleDisplay.data = new float[]{NumberUtils.toInt((String)stringArray[0]), NumberUtils.toInt((String)stringArray[1]), NumberUtils.toInt((String)stringArray[2]), stringArray.length > 3 ? NumberUtils.toFloat((String)stringArray[3]) : 1.0f};
        }
        return particleDisplay;
    }

    @Nonnull
    public static Location rotate(@Nonnull Location location, double d, double d2, double d3, @Nullable Vector vector) {
        if (vector == null) {
            return ParticleDisplay.cloneLocation(location).add(d, d2, d3);
        }
        Vector vector2 = new Vector(d, d2, d3);
        XParticle.rotateAround(vector2, vector.getX(), vector.getY(), vector.getZ());
        return ParticleDisplay.cloneLocation(location).add(vector2);
    }

    @Nonnull
    private static Location cloneLocation(@Nonnull Location location) {
        return new Location(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public String toString() {
        return "ParticleDisplay:[Particle=" + this.particle + ", Count=" + this.count + ", Offset:{" + this.offsetx + ", " + this.offsety + ", " + this.offsetz + "}, Extra=" + this.extra + ", Data=" + (this.data == null ? "null" : (this.data instanceof float[] ? Arrays.toString((float[])this.data) : this.data));
    }

    @Nonnull
    public ParticleDisplay withCount(int n) {
        this.count = n;
        return this;
    }

    @Nonnull
    public ParticleDisplay withExtra(double d) {
        this.extra = d;
        return this;
    }

    @Nonnull
    public ParticleDisplay withColor(@Nonnull Color color, float f) {
        this.data = new float[]{color.getRed(), color.getGreen(), color.getBlue(), f};
        return this;
    }

    @Nonnull
    public ParticleDisplay withEntity(@Nullable Entity entity) {
        return this.withLocationCaller(() -> ((Entity)entity).getLocation());
    }

    @Nonnull
    public ParticleDisplay withLocationCaller(@Nullable Callable<Location> callable) {
        this.locationCaller = callable;
        return this;
    }

    @Nullable
    public Location getLocation() {
        try {
            return this.locationCaller == null ? this.location : this.locationCaller.call();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.location;
        }
    }

    @Nonnull
    public ParticleDisplay faceEntity(@Nonnull Entity entity) {
        Objects.requireNonNull(entity, "Cannot face null entity");
        Location location = entity.getLocation();
        this.rotation = new Vector(Math.toRadians(location.getPitch() + 90.0f), Math.toRadians(-location.getYaw()), 0.0);
        return this;
    }

    @Nullable
    public Location cloneLocation(double d, double d2, double d3) {
        return this.location == null ? null : ParticleDisplay.cloneLocation(this.location).add(d, d2, d3);
    }

    @Nonnull
    public ParticleDisplay cloneWithLocation(double d, double d2, double d3) {
        ParticleDisplay particleDisplay = this.clone();
        if (this.location == null) {
            return particleDisplay;
        }
        particleDisplay.location.add(d, d2, d3);
        return particleDisplay;
    }

    @Nonnull
    public ParticleDisplay clone() {
        ParticleDisplay particleDisplay = new ParticleDisplay(this.particle, this.locationCaller, this.location == null ? null : ParticleDisplay.cloneLocation(this.location), this.count, this.offsetx, this.offsety, this.offsetz, this.extra);
        if (this.rotation != null) {
            particleDisplay.rotation = new Vector(this.rotation.getX(), this.rotation.getY(), this.rotation.getZ());
        }
        particleDisplay.data = this.data;
        return particleDisplay;
    }

    @Nonnull
    public ParticleDisplay rotate(@Nonnull Vector vector) {
        Objects.requireNonNull(vector, "Cannot rotate ParticleDisplay with null vector");
        if (this.rotation == null) {
            this.rotation = vector;
        } else {
            this.rotation.add(vector);
        }
        return this;
    }

    @Nonnull
    public ParticleDisplay rotate(double d, double d2, double d3) {
        return this.rotate(new Vector(d, d2, d3));
    }

    @Nonnull
    public ParticleDisplay offset(double d, double d2, double d3) {
        this.offsetx = d;
        this.offsety = d2;
        this.offsetz = d3;
        return this;
    }

    @Nonnull
    public ParticleDisplay directional() {
        this.count = 0;
        return this;
    }

    public boolean isDirectional() {
        return this.count == 0;
    }

    public void spawn() {
        this.spawn(this.getLocation());
    }

    @Nonnull
    public Location spawn(@Nonnull Vector vector) {
        Objects.requireNonNull(vector, "Cannot add xyz of null vector to ParticleDisplay");
        return this.spawn(vector.getX(), vector.getY(), vector.getZ());
    }

    @Nonnull
    public Location spawn(double d, double d2, double d3) {
        return this.spawn(ParticleDisplay.rotate(this.getLocation(), d, d2, d3, this.rotation));
    }

    @Nonnull
    public Location spawn(@Nonnull Location location) {
        return this.spawn(location, null);
    }

    @Nonnull
    public Location spawn(@Nonnull Location location, Player ... playerArray) {
        block12: {
            block11: {
                if (this.data == null) break block11;
                if (!(this.data instanceof float[])) break block12;
                float[] fArray = (float[])this.data;
                if (ISFLAT) {
                    Particle.DustOptions dustOptions = new Particle.DustOptions(org.bukkit.Color.fromRGB((int)((int)fArray[0]), (int)((int)fArray[1]), (int)((int)fArray[2])), fArray[3]);
                    if (playerArray == null) {
                        location.getWorld().spawnParticle(this.particle, location, this.count, this.offsetx, this.offsety, this.offsetz, this.extra, (Object)dustOptions);
                    } else {
                        for (Player player : playerArray) {
                            player.spawnParticle(this.particle, location, this.count, this.offsetx, this.offsety, this.offsetz, this.extra, (Object)dustOptions);
                        }
                    }
                } else if (playerArray == null) {
                    location.getWorld().spawnParticle(this.particle, location, this.count, (double)((int)fArray[0]), (double)((int)fArray[1]), (double)((int)fArray[2]), (double)fArray[3]);
                } else {
                    for (Player player : playerArray) {
                        player.spawnParticle(this.particle, location, this.count, (double)((int)fArray[0]), (double)((int)fArray[1]), (double)((int)fArray[2]), (double)fArray[3]);
                    }
                }
                break block12;
            }
            if (playerArray == null) {
                location.getWorld().spawnParticle(this.particle, location, this.count, this.offsetx, this.offsety, this.offsetz, this.extra);
            } else {
                for (Player player : playerArray) {
                    player.spawnParticle(this.particle, location, this.count, this.offsetx, this.offsety, this.offsetz, this.extra);
                }
            }
        }
        return location;
    }
}

