/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.xseries.messages;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.utils.xseries.ReflectionUtils;

public class ActionBar {
    private static final boolean SIXTEEN;
    private static final boolean SPIGOT;
    private static final MethodHandle CHAT_COMPONENT_TEXT;
    private static final MethodHandle PACKET_PLAY_OUT_CHAT;
    private static final Object CHAT_MESSAGE_TYPE;

    private ActionBar() {
    }

    public static void sendActionBar(@Nonnull Player player, @Nullable String string) {
        Objects.requireNonNull(player, "Cannot send action bar to null player");
        if (SPIGOT) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)string));
            return;
        }
        try {
            Object object = CHAT_COMPONENT_TEXT.invoke(string);
            Object object2 = SIXTEEN ? PACKET_PLAY_OUT_CHAT.invoke(object, CHAT_MESSAGE_TYPE, player.getUniqueId()) : PACKET_PLAY_OUT_CHAT.invoke(object, CHAT_MESSAGE_TYPE);
            ReflectionUtils.sendPacket(player, object2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void sendPlayersActionBar(@Nullable String string) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ActionBar.sendActionBar(player, string);
        }
    }

    public static void clearActionBar(@Nonnull Player player) {
        ActionBar.sendActionBar(player, " ");
    }

    public static void clearPlayersActionBar() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ActionBar.clearActionBar(player);
        }
    }

    public static void sendActionBarWhile(@Nonnull JavaPlugin javaPlugin, final @Nonnull Player player, final @Nullable String string, final @Nonnull Callable<Boolean> callable) {
        new BukkitRunnable(){

            public void run() {
                try {
                    if (!((Boolean)callable.call()).booleanValue()) {
                        this.cancel();
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ActionBar.sendActionBar(player, string);
            }
        }.runTaskTimerAsynchronously((Plugin)javaPlugin, 0L, 40L);
    }

    public static void sendActionBarWhile(@Nonnull JavaPlugin javaPlugin, final @Nonnull Player player, final @Nullable Callable<String> callable, final @Nonnull Callable<Boolean> callable2) {
        new BukkitRunnable(){

            public void run() {
                try {
                    if (!((Boolean)callable2.call()).booleanValue()) {
                        this.cancel();
                        return;
                    }
                    ActionBar.sendActionBar(player, (String)callable.call());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)javaPlugin, 0L, 40L);
    }

    public static void sendActionBar(@Nonnull JavaPlugin javaPlugin, final @Nonnull Player player, final @Nullable String string, final long l) {
        if (l < 1L) {
            return;
        }
        new BukkitRunnable(){
            long repeater;
            {
                this.repeater = l;
            }

            public void run() {
                ActionBar.sendActionBar(player, string);
                this.repeater -= 40L;
                if (this.repeater - 40L < -20L) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)javaPlugin, 0L, 40L);
    }

    static {
        boolean bl = false;
        if (Material.getMaterial((String)"KNOWLEDGE_BOOK") != null) {
            try {
                Class.forName("org.spigotmc.SpigotConfig");
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        SPIGOT = bl;
        try {
            Class.forName("org.bukkit.entity.Zoglin");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        SIXTEEN = bl;
        MethodHandle methodHandle = null;
        MethodHandle methodHandle2 = null;
        Byte by = null;
        if (!SPIGOT) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> clazz = ReflectionUtils.getNMSClass("PacketPlayOutChat");
            Class<?> clazz2 = ReflectionUtils.getNMSClass("IChatBaseComponent");
            try {
                Class<?> clazz3 = Class.forName(ReflectionUtils.NMS + "ChatMessageType");
                MethodType methodType = SIXTEEN ? MethodType.methodType(Void.TYPE, clazz2, clazz3, UUID.class) : MethodType.methodType(Void.TYPE, clazz2, clazz3);
                for (Object obj : clazz3.getEnumConstants()) {
                    String string = obj.toString();
                    if (!string.equals("GAME_INFO") && !string.equalsIgnoreCase("ACTION_BAR")) continue;
                    by = obj;
                    break;
                }
                Class<?> clazz4 = ReflectionUtils.getNMSClass("ChatComponentText");
                methodHandle2 = lookup.findConstructor(clazz4, MethodType.methodType(Void.TYPE, String.class));
                methodHandle = lookup.findConstructor(clazz, methodType);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                try {
                    by = 2;
                    Class<?> clazz4 = ReflectionUtils.getNMSClass("ChatComponentText");
                    methodHandle2 = lookup.findConstructor(clazz4, MethodType.methodType(Void.TYPE, String.class));
                    methodHandle = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, clazz2, Byte.TYPE));
                }
                catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException2) {
                    reflectiveOperationException2.printStackTrace();
                }
            }
        }
        CHAT_MESSAGE_TYPE = by;
        CHAT_COMPONENT_TEXT = methodHandle2;
        PACKET_PLAY_OUT_CHAT = methodHandle;
    }
}

