/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.xseries;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import org.skills.utils.xseries.SkullUtils;
import org.skills.utils.xseries.XEnchantment;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XPotion;

public final class XItemStack {
    private XItemStack() {
    }

    /*
     * WARNING - void declaration
     */
    public static void serialize(@Nonnull ItemStack itemStack, @Nonnull ConfigurationSection configurationSection) {
        Object object2;
        Object object4;
        Objects.requireNonNull(itemStack, "Cannot serialize a null item");
        Objects.requireNonNull(configurationSection, "Cannot serialize item from a null configuration section.");
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta.hasDisplayName()) {
            configurationSection.set("name", (Object)ChatColor.stripColor((String)itemMeta.getDisplayName()));
        }
        if (itemMeta.hasLore()) {
            object4 = new ArrayList();
            for (String string : itemMeta.getLore()) {
                object4.add(ChatColor.stripColor((String)string));
            }
            configurationSection.set("lore", object4);
        }
        if (itemStack.getAmount() > 1) {
            configurationSection.set("amount", (Object)itemStack.getAmount());
        }
        if (XMaterial.isNewVersion()) {
            if (itemMeta instanceof Damageable && (object4 = (Damageable)itemMeta).hasDamage()) {
                configurationSection.set("damage", (Object)object4.getDamage());
            }
        } else if (itemStack.getType().getMaxDurability() > 0) {
            configurationSection.set("damage", (Object)itemStack.getDurability());
        }
        configurationSection.set("material", (Object)itemStack.getType().name());
        if (itemMeta.hasCustomModelData()) {
            configurationSection.set("custom-model", (Object)itemMeta.getCustomModelData());
        }
        if (itemMeta.isUnbreakable()) {
            configurationSection.set("unbreakable", (Object)true);
        }
        for (Map.Entry n : itemMeta.getEnchants().entrySet()) {
            String string = "enchants." + XEnchantment.matchXEnchantment((Enchantment)n.getKey()).name();
            configurationSection.set(string, n.getValue());
        }
        if (!itemMeta.getItemFlags().isEmpty()) {
            object4 = new ArrayList();
            for (ItemFlag itemFlag : itemMeta.getItemFlags()) {
                object4.add(itemFlag.name());
            }
            configurationSection.set("flags", object4);
        }
        if (XMaterial.supports(9) && itemMeta.hasAttributeModifiers()) {
            for (Map.Entry entry : itemMeta.getAttributeModifiers().entries()) {
                String string = "attributes." + ((Attribute)entry.getKey()).name() + '.';
                object2 = (AttributeModifier)entry.getValue();
                configurationSection.set(string + "id", (Object)object2.getUniqueId().toString());
                configurationSection.set(string + "name", (Object)object2.getName());
                configurationSection.set(string + "amount", (Object)object2.getAmount());
                configurationSection.set(string + "operation", (Object)object2.getOperation().name());
                configurationSection.set(string + "slot", (Object)object2.getSlot().name());
            }
        }
        if (itemMeta instanceof BlockStateMeta) {
            object4 = (BlockStateMeta)itemStack.getItemMeta();
            BlockState blockState = object4.getBlockState();
            if (XMaterial.supports(11) && blockState instanceof ShulkerBox) {
                ShulkerBox shulkerBox = (ShulkerBox)blockState;
                object2 = configurationSection.createSection("shulker");
                int n = 0;
                for (ItemStack itemStack2 : shulkerBox.getInventory().getContents()) {
                    if (itemStack2 != null) {
                        XItemStack.serialize(itemStack2, object2.createSection(Integer.toString(n)));
                    }
                    ++n;
                }
            } else if (blockState instanceof CreatureSpawner) {
                CreatureSpawner creatureSpawner = (CreatureSpawner)blockState;
                configurationSection.set("spawner", (Object)creatureSpawner.getSpawnedType().name());
            }
        } else if (itemMeta instanceof EnchantmentStorageMeta) {
            object4 = (EnchantmentStorageMeta)itemMeta;
            for (Map.Entry entry : object4.getStoredEnchants().entrySet()) {
                object2 = "stored-enchants." + XEnchantment.matchXEnchantment((Enchantment)entry.getKey()).name();
                configurationSection.set((String)object2, entry.getValue());
            }
        } else if (itemMeta instanceof SkullMeta) {
            configurationSection.set("skull", (Object)SkullUtils.getSkinValue(itemMeta));
        } else if (itemMeta instanceof BannerMeta) {
            object4 = (BannerMeta)itemMeta;
            ConfigurationSection configurationSection2 = configurationSection.createSection("patterns");
            for (Object object2 : object4.getPatterns()) {
                configurationSection2.set(object2.getPattern().name(), (Object)object2.getColor().name());
            }
        } else if (itemMeta instanceof LeatherArmorMeta) {
            object4 = (LeatherArmorMeta)itemMeta;
            Color color = object4.getColor();
            configurationSection.set("color", (Object)(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue()));
        } else if (itemMeta instanceof PotionMeta) {
            if (XMaterial.supports(9)) {
                object4 = (PotionMeta)itemMeta;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Object object2 : object4.getCustomEffects()) {
                    arrayList.add(object2.getType().getName() + ", " + object2.getDuration() + ", " + object2.getAmplifier());
                }
                configurationSection.set("custom-effects", arrayList);
                PotionData potionData = object4.getBasePotionData();
                configurationSection.set("base-effect", (Object)(potionData.getType().name() + ", " + potionData.isExtended() + ", " + potionData.isUpgraded()));
                if (object4.hasColor()) {
                    configurationSection.set("color", (Object)object4.getColor().asRGB());
                }
            } else if (itemStack.getDurability() != 0) {
                object4 = Potion.fromItemStack((ItemStack)itemStack);
                configurationSection.set("level", (Object)object4.getLevel());
                configurationSection.set("base-effect", (Object)(object4.getType().name() + ", " + object4.hasExtendedDuration() + ", " + object4.isSplash()));
            }
        } else if (itemMeta instanceof FireworkMeta) {
            object4 = (FireworkMeta)itemMeta;
            configurationSection.set("power", (Object)object4.getPower());
            boolean bl = false;
            for (Object object2 : object4.getEffects()) {
                void var4_17;
                configurationSection.set("firework." + (int)var4_17 + ".type", (Object)object2.getType().name());
                ConfigurationSection configurationSection3 = configurationSection.getConfigurationSection("firework." + (int)var4_17);
                configurationSection3.set("flicker", (Object)object2.hasFlicker());
                configurationSection3.set("trail", (Object)object2.hasTrail());
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (Color color : object2.getColors()) {
                    arrayList.add(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
                }
                configurationSection3.set("base-colors", arrayList);
                for (Color color : object2.getFadeColors()) {
                    arrayList2.add(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
                }
                configurationSection3.set("fade-colors", arrayList2);
                ++var4_17;
            }
        } else if (XMaterial.supports(14)) {
            if (itemMeta instanceof CrossbowMeta) {
                object4 = (CrossbowMeta)itemMeta;
                boolean bl = false;
                for (Object object2 : object4.getChargedProjectiles()) {
                    void var4_19;
                    XItemStack.serialize((ItemStack)object2, configurationSection.getConfigurationSection("projectiles." + (int)var4_19));
                    ++var4_19;
                }
            } else if (itemMeta instanceof TropicalFishBucketMeta) {
                object4 = (TropicalFishBucketMeta)itemMeta;
                configurationSection.set("pattern", (Object)object4.getPattern().name());
                configurationSection.set("color", (Object)object4.getBodyColor().name());
                configurationSection.set("pattern-color", (Object)object4.getPatternColor().name());
            } else if (itemMeta instanceof SuspiciousStewMeta) {
                object4 = (SuspiciousStewMeta)itemMeta;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Object object2 : object4.getCustomEffects()) {
                    arrayList.add(object2.getType().getName() + ", " + object2.getDuration() + ", " + object2.getAmplifier());
                }
                configurationSection.set("effects", arrayList);
            }
        }
    }

    @Nullable
    public static ItemStack deserialize(@Nonnull ConfigurationSection configurationSection) {
        List list;
        int n;
        Object object;
        Object object22;
        Object object32;
        Object object4;
        int n2;
        Objects.requireNonNull(configurationSection, "Cannot deserialize item to a null configuration section.");
        String string = configurationSection.getString("material");
        if (string == null) {
            return null;
        }
        Optional<XMaterial> optional = XMaterial.matchXMaterial(string);
        if (!optional.isPresent()) {
            return null;
        }
        ItemStack itemStack = optional.get().parseItem();
        if (itemStack == null) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        int n3 = configurationSection.getInt("amount");
        if (n3 > 1) {
            itemStack.setAmount(n3);
        }
        if (XMaterial.isNewVersion()) {
            if (itemMeta instanceof Damageable && (n2 = configurationSection.getInt("damage")) > 0) {
                ((Damageable)itemMeta).setDamage(n2);
            }
        } else {
            n2 = configurationSection.getInt("damage");
            if (n2 > 0) {
                itemStack.setDurability((short)n2);
            }
        }
        if (optional.get() == XMaterial.PLAYER_HEAD) {
            String string2 = configurationSection.getString("skull");
            if (string2 != null) {
                SkullUtils.applySkin(itemMeta, string2);
            }
        } else if (itemMeta instanceof BannerMeta) {
            BannerMeta bannerMeta = (BannerMeta)itemMeta;
            object4 = configurationSection.getConfigurationSection("patterns");
            if (object4 != null) {
                for (Object object32 : object4.getKeys(false)) {
                    PatternType patternType = PatternType.getByIdentifier((String)object32);
                    if (patternType == null) {
                        patternType = (PatternType)Enums.getIfPresent(PatternType.class, (String)((String)object32).toUpperCase(Locale.ENGLISH)).or((Object)PatternType.BASE);
                    }
                    DyeColor dyeColor = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)object4.getString((String)object32).toUpperCase(Locale.ENGLISH)).or((Object)DyeColor.WHITE);
                    bannerMeta.addPattern(new Pattern(dyeColor, patternType));
                }
            }
        } else if (itemMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
            object4 = configurationSection.getString("color");
            if (object4 != null) {
                leatherArmorMeta.setColor(XItemStack.parseColor((String)object4));
            }
        } else if (itemMeta instanceof PotionMeta) {
            if (XMaterial.supports(9)) {
                PotionMeta potionMeta = (PotionMeta)itemMeta;
                for (Object object22 : configurationSection.getStringList("custom-effects")) {
                    object32 = XPotion.parsePotionEffectFromString((String)object22);
                    potionMeta.addCustomEffect((PotionEffect)object32, true);
                }
                object4 = configurationSection.getString("base-effect");
                if (!Strings.isNullOrEmpty((String)object4)) {
                    object22 = StringUtils.split((String)object4, (char)',');
                    object32 = (PotionType)Enums.getIfPresent(PotionType.class, (String)object22[0].trim().toUpperCase(Locale.ENGLISH)).or((Object)PotionType.UNCRAFTABLE);
                    boolean bl = ((ConfigurationSection)object22).length != 1 && Boolean.parseBoolean(object22[1].trim());
                    boolean bl2 = ((ConfigurationSection)object22).length > 2 && Boolean.parseBoolean(object22[2].trim());
                    object = new PotionData((PotionType)object32, bl, bl2);
                    potionMeta.setBasePotionData((PotionData)object);
                }
                if (configurationSection.contains("color")) {
                    potionMeta.setColor(Color.fromRGB((int)configurationSection.getInt("color")));
                }
            } else if (configurationSection.contains("level")) {
                n2 = configurationSection.getInt("level");
                object4 = configurationSection.getString("base-effect");
                if (!Strings.isNullOrEmpty((String)object4)) {
                    object22 = StringUtils.split((String)object4, (char)',');
                    object32 = (PotionType)Enums.getIfPresent(PotionType.class, (String)object22[0].trim().toUpperCase(Locale.ENGLISH)).or((Object)PotionType.SLOWNESS);
                    boolean bl = ((ConfigurationSection)object22).length != 1 && Boolean.parseBoolean(object22[1].trim());
                    boolean bl3 = ((ConfigurationSection)object22).length > 2 && Boolean.parseBoolean(object22[2].trim());
                    itemStack = new Potion((PotionType)object32, n2, bl3, bl).toItemStack(1);
                }
            }
        } else if (itemMeta instanceof BlockStateMeta) {
            BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
            object4 = blockStateMeta.getBlockState();
            if (object4 instanceof CreatureSpawner) {
                object22 = (CreatureSpawner)object4;
                object22.setSpawnedType((EntityType)Enums.getIfPresent(EntityType.class, (String)configurationSection.getString("spawner").toUpperCase(Locale.ENGLISH)).orNull());
                object22.update(true);
                blockStateMeta.setBlockState((BlockState)object22);
            } else if (XMaterial.supports(11) && object4 instanceof ShulkerBox) {
                object22 = configurationSection.getConfigurationSection("shulker");
                if (object22 != null) {
                    object32 = (ShulkerBox)object4;
                    for (String string3 : object22.getKeys(false)) {
                        object = XItemStack.deserialize(object22.getConfigurationSection(string3));
                        int n4 = NumberUtils.toInt((String)string3, (int)0);
                        object32.getInventory().setItem(n4, (ItemStack)object);
                    }
                    object32.update(true);
                    blockStateMeta.setBlockState((BlockState)object32);
                }
            } else if (object4 instanceof Banner) {
                object22 = (Banner)object4;
                object32 = configurationSection.getConfigurationSection("patterns");
                if (object32 != null) {
                    for (String string3 : object32.getKeys(false)) {
                        object = PatternType.getByIdentifier((String)string3);
                        if (object == null) {
                            object = (PatternType)Enums.getIfPresent(PatternType.class, (String)string3.toUpperCase(Locale.ENGLISH)).or((Object)PatternType.BASE);
                        }
                        DyeColor dyeColor = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)object32.getString(string3).toUpperCase(Locale.ENGLISH)).or((Object)DyeColor.WHITE);
                        object22.addPattern(new Pattern(dyeColor, (PatternType)object));
                    }
                    object22.update(true);
                    blockStateMeta.setBlockState((BlockState)object22);
                }
            }
        } else if (itemMeta instanceof FireworkMeta) {
            FireworkMeta fireworkMeta = (FireworkMeta)itemMeta;
            fireworkMeta.setPower(configurationSection.getInt("power"));
            object4 = configurationSection.getConfigurationSection("firework");
            if (object4 != null) {
                object22 = FireworkEffect.builder();
                object32 = object4.getKeys(false).iterator();
                while (object32.hasNext()) {
                    String string4 = (String)object32.next();
                    ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("firework." + string4);
                    object22.flicker(configurationSection2.getBoolean("flicker"));
                    object22.trail(configurationSection2.getBoolean("trail"));
                    object22.with((FireworkEffect.Type)Enums.getIfPresent(FireworkEffect.Type.class, (String)configurationSection2.getString("type").toUpperCase(Locale.ENGLISH)).or((Object)FireworkEffect.Type.STAR));
                    object = new ArrayList();
                    for (String string5 : configurationSection2.getStringList("colors")) {
                        object.add(XItemStack.parseColor(string5));
                    }
                    object22.withColor((Iterable)object);
                    object.clear();
                    for (String string5 : configurationSection2.getStringList("fade-colors")) {
                        object.add(XItemStack.parseColor(string5));
                    }
                    object22.withFade((Iterable)object);
                    fireworkMeta.addEffect(object22.build());
                }
            }
        } else if (XMaterial.supports(14)) {
            if (itemMeta instanceof CrossbowMeta) {
                CrossbowMeta crossbowMeta = (CrossbowMeta)itemMeta;
                for (Object object22 : configurationSection.getConfigurationSection("projectiles").getKeys(false)) {
                    object32 = XItemStack.deserialize(configurationSection.getConfigurationSection("projectiles." + (String)object22));
                    crossbowMeta.addChargedProjectile((ItemStack)object32);
                }
            } else if (itemMeta instanceof TropicalFishBucketMeta) {
                TropicalFishBucketMeta tropicalFishBucketMeta = (TropicalFishBucketMeta)itemMeta;
                object4 = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)configurationSection.getString("color")).or((Object)DyeColor.WHITE);
                object22 = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)configurationSection.getString("pattern-color")).or((Object)DyeColor.WHITE);
                object32 = (TropicalFish.Pattern)Enums.getIfPresent(TropicalFish.Pattern.class, (String)configurationSection.getString("pattern")).or((Object)TropicalFish.Pattern.BETTY);
                tropicalFishBucketMeta.setBodyColor((DyeColor)object4);
                tropicalFishBucketMeta.setPatternColor((DyeColor)object22);
                tropicalFishBucketMeta.setPattern((TropicalFish.Pattern)object32);
            }
        } else if (XMaterial.supports(15) && itemMeta instanceof SuspiciousStewMeta) {
            SuspiciousStewMeta suspiciousStewMeta = (SuspiciousStewMeta)itemMeta;
            for (Object object22 : configurationSection.getStringList("effects")) {
                object32 = XPotion.parsePotionEffectFromString((String)object22);
                suspiciousStewMeta.addCustomEffect((PotionEffect)object32, true);
            }
        }
        String string6 = configurationSection.getString("name");
        if (!Strings.isNullOrEmpty((String)string6)) {
            object4 = ChatColor.translateAlternateColorCodes((char)'&', (String)string6);
            itemMeta.setDisplayName((String)object4);
        } else if (string6 != null && string6.isEmpty()) {
            itemMeta.setDisplayName(" ");
        }
        if (XMaterial.supports(11)) {
            itemMeta.setUnbreakable(configurationSection.getBoolean("unbreakable"));
        }
        if (XMaterial.supports(14) && (n = configurationSection.getInt("model-data")) != 0) {
            itemMeta.setCustomModelData(Integer.valueOf(n));
        }
        if (!(list = configurationSection.getStringList("lore")).isEmpty()) {
            object22 = new ArrayList();
            object32 = "";
            for (String string7 : list) {
                if (string7.isEmpty()) {
                    object22.add(" ");
                    continue;
                }
                for (Object object5 : StringUtils.splitPreserveAllTokens((String)string7, (char)'\n')) {
                    if (object5.isEmpty()) {
                        object22.add(" ");
                        continue;
                    }
                    object5 = (String)object32 + ChatColor.translateAlternateColorCodes((char)'&', (String)object5);
                    object22.add(object5);
                    object32 = ChatColor.getLastColors((String)object5);
                }
            }
            itemMeta.setLore((List)object22);
        } else {
            object22 = configurationSection.getString("lore");
            if (!Strings.isNullOrEmpty((String)object22)) {
                object32 = new ArrayList();
                String string8 = "";
                for (String string5 : StringUtils.splitPreserveAllTokens((String)object22, (char)'\n')) {
                    if (string5.isEmpty()) {
                        object32.add(" ");
                        continue;
                    }
                    string5 = string8 + ChatColor.translateAlternateColorCodes((char)'&', (String)string5);
                    object32.add(string5);
                    string8 = ChatColor.getLastColors((String)string5);
                }
                itemMeta.setLore((List)object32);
            }
        }
        object22 = configurationSection.getConfigurationSection("enchants");
        if (object22 != null) {
            object32 = object22.getKeys(false).iterator();
            while (object32.hasNext()) {
                String string9 = (String)object32.next();
                Optional<XEnchantment> optional2 = XEnchantment.matchXEnchantment(string9);
                optional2.ifPresent(arg_0 -> XItemStack.lambda$deserialize$0(itemMeta, (ConfigurationSection)object22, string9, arg_0));
            }
        }
        if ((object32 = configurationSection.getConfigurationSection("stored-enchants")) != null) {
            for (String string10 : object32.getKeys(false)) {
                object = XEnchantment.matchXEnchantment(string10);
                EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
                ((Optional)object).ifPresent(arg_0 -> XItemStack.lambda$deserialize$1(enchantmentStorageMeta, (ConfigurationSection)object32, string10, arg_0));
            }
        }
        List list2 = configurationSection.getStringList("flags");
        ConfigurationSection configurationSection3 = list2.iterator();
        while (configurationSection3.hasNext()) {
            object = (String)configurationSection3.next();
            if (((String)(object = ((String)object).toUpperCase(Locale.ENGLISH))).equals("ALL")) {
                itemMeta.addItemFlags(ItemFlag.values());
                break;
            }
            ItemFlag itemFlag = (ItemFlag)Enums.getIfPresent(ItemFlag.class, (String)object).orNull();
            if (itemFlag == null) continue;
            itemMeta.addItemFlags(new ItemFlag[]{itemFlag});
        }
        if (XMaterial.supports(9) && (configurationSection3 = configurationSection.getConfigurationSection("attributes")) != null) {
            for (String string11 : configurationSection3.getKeys(false)) {
                Object object5;
                Attribute attribute = (Attribute)Enums.getIfPresent(Attribute.class, (String)string11.toUpperCase(Locale.ENGLISH)).orNull();
                if (attribute == null) continue;
                object5 = configurationSection3.getString("id");
                UUID uUID = object5 != null ? UUID.fromString((String)object5) : UUID.randomUUID();
                AttributeModifier attributeModifier = new AttributeModifier(uUID, configurationSection3.getString("name"), (double)configurationSection3.getInt("amount"), (AttributeModifier.Operation)Enums.getIfPresent(AttributeModifier.Operation.class, (String)configurationSection3.getString("operation")).or((Object)AttributeModifier.Operation.ADD_NUMBER), (EquipmentSlot)Enums.getIfPresent(EquipmentSlot.class, (String)configurationSection3.getString("slot")).or((Object)EquipmentSlot.HAND));
                itemMeta.addAttributeModifier(attribute, attributeModifier);
            }
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Nonnull
    public static Color parseColor(@Nullable String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return Color.BLACK;
        }
        String[] stringArray = StringUtils.split((String)StringUtils.deleteWhitespace((String)string), (char)',');
        if (stringArray.length < 3) {
            return Color.WHITE;
        }
        return Color.fromRGB((int)NumberUtils.toInt((String)stringArray[0], (int)0), (int)NumberUtils.toInt((String)stringArray[1], (int)0), (int)NumberUtils.toInt((String)stringArray[2], (int)0));
    }

    @Nonnull
    public static List<ItemStack> giveOrDrop(@Nonnull Player player, ItemStack ... itemStackArray) {
        return XItemStack.giveOrDrop(player, false, itemStackArray);
    }

    @Nonnull
    public static List<ItemStack> giveOrDrop(@Nonnull Player player, boolean bl, ItemStack ... itemStackArray) {
        if (itemStackArray == null || itemStackArray.length == 0) {
            return new ArrayList<ItemStack>();
        }
        List<ItemStack> list = XItemStack.addItems((Inventory)player.getInventory(), bl, itemStackArray);
        World world = player.getWorld();
        Location location = player.getLocation();
        for (ItemStack itemStack : list) {
            world.dropItemNaturally(location, itemStack);
        }
        return list;
    }

    @Nonnull
    public static List<ItemStack> addItems(@Nonnull Inventory inventory, boolean bl, ItemStack ... itemStackArray) {
        Objects.requireNonNull(inventory, "Cannot add items to null inventory");
        Objects.requireNonNull(itemStackArray, "Cannot add null items to inventory");
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>(itemStackArray.length);
        int n = 0;
        int n2 = inventory.getSize();
        block0: for (ItemStack itemStack : itemStackArray) {
            int n3 = 0;
            while (true) {
                int n4;
                int n5;
                if ((n5 = XItemStack.firstPartial(inventory, itemStack, n3)) == -1) {
                    if (n != -1) {
                        n = XItemStack.firstEmpty(inventory, n);
                    }
                    if (n == -1) {
                        arrayList.add(itemStack);
                        continue block0;
                    }
                    n3 = n;
                    int n6 = bl ? itemStack.getMaxStackSize() : inventory.getMaxStackSize();
                    n4 = itemStack.getAmount();
                    if (n4 <= n6) {
                        inventory.setItem(n, itemStack);
                        continue block0;
                    }
                    ItemStack itemStack2 = itemStack.clone();
                    itemStack2.setAmount(n6);
                    inventory.setItem(n, itemStack2);
                    itemStack.setAmount(n4 - n6);
                    if (++n != n2) continue;
                    n = -1;
                    continue;
                }
                ItemStack itemStack3 = inventory.getItem(n5);
                n4 = itemStack3.getMaxStackSize();
                int n7 = itemStack3.getAmount();
                int n8 = itemStack.getAmount();
                int n9 = n8 + n7;
                if (n9 <= n4) {
                    itemStack3.setAmount(n9);
                    inventory.setItem(n5, itemStack3);
                    continue block0;
                }
                itemStack3.setAmount(n4);
                inventory.setItem(n5, itemStack3);
                itemStack.setAmount(n9 - n4);
                n3 = n5 + 1;
            }
        }
        return arrayList;
    }

    public static int firstPartial(@Nonnull Inventory inventory, @Nullable ItemStack itemStack, int n) {
        if (itemStack != null) {
            ItemStack[] itemStackArray = inventory.getStorageContents();
            int n2 = itemStackArray.length;
            if (n < 0 || n >= n2) {
                throw new IndexOutOfBoundsException("Begin Index: " + n + ", Size: " + n2);
            }
            while (n < n2) {
                ItemStack itemStack2 = itemStackArray[n];
                if (itemStack2 != null && itemStack2.getAmount() < itemStack2.getMaxStackSize() && itemStack2.isSimilar(itemStack)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    @Nonnull
    public static List<ItemStack> stack(@Nonnull Collection<ItemStack> collection) {
        Objects.requireNonNull(collection, "Cannot stack null items");
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (ItemStack itemStack : collection) {
            if (itemStack == null) continue;
            boolean bl = true;
            for (ItemStack itemStack2 : arrayList) {
                if (!itemStack2.isSimilar(itemStack)) continue;
                itemStack2.setAmount(itemStack2.getAmount() + itemStack.getAmount());
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(itemStack.clone());
        }
        return arrayList;
    }

    public static int firstEmpty(@Nonnull Inventory inventory, int n) {
        ItemStack[] itemStackArray = inventory.getStorageContents();
        int n2 = itemStackArray.length;
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("Begin Index: " + n + ", Size: " + n2);
        }
        while (n < n2) {
            if (itemStackArray[n] == null) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static /* synthetic */ void lambda$deserialize$1(EnchantmentStorageMeta enchantmentStorageMeta, ConfigurationSection configurationSection, String string, XEnchantment xEnchantment) {
        enchantmentStorageMeta.addStoredEnchant(xEnchantment.parseEnchantment(), configurationSection.getInt(string), true);
    }

    private static /* synthetic */ void lambda$deserialize$0(ItemMeta itemMeta, ConfigurationSection configurationSection, String string, XEnchantment xEnchantment) {
        itemMeta.addEnchant(xEnchantment.parseEnchantment(), configurationSection.getInt(string), true);
    }
}

