/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.xseries;

import com.google.common.base.Enums;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Cat;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Husk;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Strider;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.ItemStack;
import org.skills.utils.xseries.XItemStack;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XPotion;

public final class XEntity {
    public static final Set<EntityType> UNDEAD;

    private XEntity() {
    }

    public static boolean isUndead(@Nullable EntityType entityType) {
        return entityType != null && UNDEAD.contains(entityType);
    }

    @Nullable
    public static Entity spawn(@Nonnull Location location, @Nonnull ConfigurationSection configurationSection) {
        Objects.requireNonNull(location, "Cannot spawn entity at a null location.");
        Objects.requireNonNull(configurationSection, "Cannot spawn entity from a null configuration section");
        String string = configurationSection.getString("type");
        if (string == null) {
            return null;
        }
        EntityType entityType = (EntityType)Enums.getIfPresent(EntityType.class, (String)string.toUpperCase(Locale.ENGLISH)).or((Object)EntityType.ZOMBIE);
        return XEntity.edit(location.getWorld().spawnEntity(location, entityType), configurationSection);
    }

    @Nonnull
    public static Entity edit(@Nonnull Entity entity, @Nonnull ConfigurationSection configurationSection) {
        int n;
        Objects.requireNonNull(entity, "Cannot edit properties of a null entity");
        Objects.requireNonNull(configurationSection, "Cannot edit an entity from a null configuration section");
        String string = configurationSection.getString("name");
        if (string != null) {
            entity.setCustomName(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
            entity.setCustomNameVisible(true);
        }
        if (configurationSection.isSet("glowing")) {
            entity.setGlowing(configurationSection.getBoolean("glowing"));
        }
        if (configurationSection.isSet("gravity")) {
            entity.setGravity(configurationSection.getBoolean("gravity"));
        }
        if (configurationSection.isSet("silent")) {
            entity.setSilent(configurationSection.getBoolean("silent"));
        }
        entity.setFireTicks(configurationSection.getInt("fire-ticks"));
        entity.setFallDistance((float)configurationSection.getInt("fall-distance"));
        entity.setInvulnerable(configurationSection.getBoolean("invulnerable"));
        int n2 = configurationSection.getInt("ticks-lived");
        if (n2 > 0) {
            entity.setTicksLived(n2);
        }
        if ((n = configurationSection.getInt("portal-cooldown", -1)) != -1) {
            entity.setPortalCooldown(n);
        }
        if (entity instanceof LivingEntity) {
            ConfigurationSection configurationSection2;
            ConfigurationSection configurationSection3;
            Object object;
            Object object2;
            Object object3;
            String string22;
            LivingEntity livingEntity = (LivingEntity)entity;
            double d = configurationSection.getDouble("health", -1.0);
            if (d > -1.0) {
                livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(d);
                livingEntity.setHealth(d);
            }
            if (XMaterial.isNewVersion()) {
                livingEntity.setAbsorptionAmount((double)configurationSection.getInt("absorption"));
            }
            if (configurationSection.isSet("AI")) {
                livingEntity.setAI(configurationSection.getBoolean("AI"));
            }
            if (configurationSection.isSet("can-pickup-items")) {
                livingEntity.setCanPickupItems(configurationSection.getBoolean("can-pickup-items"));
            }
            if (configurationSection.isSet("collidable")) {
                livingEntity.setCollidable(configurationSection.getBoolean("collidable"));
            }
            if (configurationSection.isSet("gliding")) {
                livingEntity.setGliding(configurationSection.getBoolean("gliding"));
            }
            if (configurationSection.isSet("remove-when-far-away")) {
                livingEntity.setRemoveWhenFarAway(configurationSection.getBoolean("remove-when-far-away"));
            }
            if (configurationSection.isSet("swimming")) {
                livingEntity.setSwimming(configurationSection.getBoolean("swimming"));
            }
            if (configurationSection.isSet("max-air")) {
                livingEntity.setMaximumAir(configurationSection.getInt("max-air"));
            }
            if (configurationSection.isSet("no-damage-ticks")) {
                livingEntity.setNoDamageTicks(configurationSection.getInt("do-damage-ticks"));
            }
            if (configurationSection.isSet("remaining-air")) {
                livingEntity.setRemainingAir(configurationSection.getInt("remaining-air"));
            }
            for (String string22 : configurationSection.getStringList("effects")) {
                livingEntity.addPotionEffect(XPotion.parsePotionEffectFromString(string22));
            }
            ConfigurationSection configurationSection4 = configurationSection.getConfigurationSection("equipment");
            if (configurationSection4 != null) {
                ConfigurationSection configurationSection5;
                string22 = livingEntity.getEquipment();
                object3 = configurationSection4.getConfigurationSection("helmet");
                if (object3 != null) {
                    string22.setHelmet(XItemStack.deserialize(object3.getConfigurationSection("item")));
                    string22.setHelmetDropChance((float)object3.getInt("drop-chance"));
                }
                if ((object2 = configurationSection4.getConfigurationSection("chestplate")) != null) {
                    string22.setChestplate(XItemStack.deserialize(object2.getConfigurationSection("item")));
                    string22.setChestplateDropChance((float)object2.getInt("drop-chance"));
                }
                if ((object = configurationSection4.getConfigurationSection("leggings")) != null) {
                    string22.setLeggings(XItemStack.deserialize(object.getConfigurationSection("item")));
                    string22.setLeggingsDropChance((float)object.getInt("drop-chance"));
                }
                if ((configurationSection3 = configurationSection4.getConfigurationSection("boots")) != null) {
                    string22.setBoots(XItemStack.deserialize(configurationSection3.getConfigurationSection("item")));
                    string22.setBootsDropChance((float)configurationSection3.getInt("drop-chance"));
                }
                if ((configurationSection5 = configurationSection4.getConfigurationSection("main-hand")) != null) {
                    string22.setItemInMainHand(XItemStack.deserialize(configurationSection5.getConfigurationSection("item")));
                    string22.setItemInMainHandDropChance((float)configurationSection5.getInt("drop-chance"));
                }
                if ((configurationSection2 = configurationSection4.getConfigurationSection("off-hand")) != null) {
                    string22.setItemInOffHand(XItemStack.deserialize(configurationSection2.getConfigurationSection("item")));
                    string22.setItemInOffHandDropChance((float)configurationSection2.getInt("drop-chance"));
                }
            }
            if (livingEntity instanceof Ageable) {
                int n3;
                string22 = (Ageable)livingEntity;
                if (configurationSection.isSet("breed")) {
                    string22.setBreed(configurationSection.getBoolean("breed"));
                }
                if (configurationSection.isSet("baby")) {
                    if (configurationSection.getBoolean("baby")) {
                        string22.setBaby();
                    } else {
                        string22.setAdult();
                    }
                }
                if ((n3 = configurationSection.getInt("age", 0)) > 0) {
                    string22.setAge(n3);
                }
                if (configurationSection.isSet("age-lock")) {
                    string22.setAgeLock(configurationSection.getBoolean("age-lock"));
                }
            }
            if (livingEntity instanceof Tameable) {
                string22 = (Tameable)livingEntity;
                string22.setTamed(configurationSection.getBoolean("tamed"));
            }
            if (livingEntity instanceof Sittable) {
                string22 = (Sittable)livingEntity;
                string22.setSitting(configurationSection.getBoolean("sitting"));
            }
            if (livingEntity instanceof Spellcaster) {
                string22 = (Spellcaster)livingEntity;
                object3 = configurationSection.getString("spell");
                if (object3 != null) {
                    string22.setSpell((Spellcaster.Spell)Enums.getIfPresent(Spellcaster.Spell.class, (String)object3).or((Object)Spellcaster.Spell.NONE));
                }
            }
            if (livingEntity instanceof ChestedHorse) {
                string22 = (ChestedHorse)livingEntity;
                string22.setCarryingChest(configurationSection.getBoolean("has-chest"));
                object3 = configurationSection.getConfigurationSection("items");
                if (object3 != null) {
                    object2 = object3.getKeys(false).iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        configurationSection3 = object3.getConfigurationSection((String)object);
                        int n4 = configurationSection3.getInt("slot", -1);
                        if (n4 == -1 || (configurationSection2 = XItemStack.deserialize(configurationSection3)) == null) continue;
                        string22.getInventory().setItem(n4, (ItemStack)configurationSection2);
                    }
                }
            }
            if (livingEntity instanceof Enderman) {
                string22 = (Enderman)livingEntity;
                object3 = configurationSection.getString("block");
                if (object3 != null && ((Optional)(object2 = XMaterial.matchXMaterial((String)object3))).isPresent() && (object = ((XMaterial)((Object)((Optional)object2).get())).parseItem()) != null) {
                    string22.setCarriedMaterial(object.getData());
                }
            } else if (livingEntity instanceof Rabbit) {
                string22 = (Rabbit)livingEntity;
                string22.setRabbitType((Rabbit.Type)Enums.getIfPresent(Rabbit.Type.class, (String)configurationSection.getString("rabbit-type")).or((Object)Rabbit.Type.WHITE));
            } else if (livingEntity instanceof Bat) {
                string22 = (Bat)livingEntity;
                if (!configurationSection.getBoolean("awake")) {
                    string22.setAwake(false);
                }
            } else if (livingEntity instanceof Wolf) {
                string22 = (Wolf)livingEntity;
                string22.setAngry(configurationSection.getBoolean("angry"));
                string22.setCollarColor((DyeColor)Enums.getIfPresent(DyeColor.class, (String)configurationSection.getString("color")).or((Object)DyeColor.GREEN));
            } else if (livingEntity instanceof Creeper) {
                string22 = (Creeper)livingEntity;
                string22.setExplosionRadius(configurationSection.getInt("explosion-radius"));
                string22.setMaxFuseTicks(configurationSection.getInt("max-fuse-ticks"));
                string22.setPowered(configurationSection.getBoolean("powered"));
            } else if (XMaterial.supports(10)) {
                if (livingEntity instanceof Husk) {
                    string22 = (Husk)livingEntity;
                    string22.setConversionTime(configurationSection.getInt("conversion-time"));
                } else if (XMaterial.supports(11)) {
                    if (livingEntity instanceof Llama) {
                        string22 = (Llama)livingEntity;
                        string22.setColor((Llama.Color)Enums.getIfPresent(Llama.Color.class, (String)configurationSection.getString("color")).or((Object)Llama.Color.WHITE));
                        string22.setStrength(configurationSection.getInt("strength"));
                    } else if (XMaterial.supports(12)) {
                        if (livingEntity instanceof Parrot) {
                            string22 = (Parrot)livingEntity;
                            string22.setVariant((Parrot.Variant)Enums.getIfPresent(Parrot.Variant.class, (String)configurationSection.getString("variant")).or((Object)Parrot.Variant.RED));
                        } else if (XMaterial.isNewVersion()) {
                            if (livingEntity instanceof Vex) {
                                string22 = (Vex)livingEntity;
                                string22.setCharging(configurationSection.getBoolean("charging"));
                            } else if (livingEntity instanceof Cat) {
                                string22 = (Cat)livingEntity;
                                string22.setCatType((Cat.Type)Enums.getIfPresent(Cat.Type.class, (String)configurationSection.getString("cat-type")).or((Object)Cat.Type.TABBY));
                                string22.setCollarColor((DyeColor)Enums.getIfPresent(DyeColor.class, (String)configurationSection.getString("color")).or((Object)DyeColor.GREEN));
                            } else if (livingEntity instanceof PufferFish) {
                                string22 = (PufferFish)livingEntity;
                                string22.setPuffState(configurationSection.getInt("puff-state"));
                            } else if (livingEntity instanceof TropicalFish) {
                                string22 = (TropicalFish)livingEntity;
                                string22.setBodyColor((DyeColor)Enums.getIfPresent(DyeColor.class, (String)configurationSection.getString("color")).or((Object)DyeColor.WHITE));
                                string22.setPattern((TropicalFish.Pattern)Enums.getIfPresent(TropicalFish.Pattern.class, (String)configurationSection.getString("pattern")).or((Object)TropicalFish.Pattern.BETTY));
                                string22.setPatternColor((DyeColor)Enums.getIfPresent(DyeColor.class, (String)configurationSection.getString("pattern-color")).or((Object)DyeColor.WHITE));
                            } else if (livingEntity instanceof EnderDragon) {
                                string22 = (EnderDragon)livingEntity;
                                string22.setPhase((EnderDragon.Phase)Enums.getIfPresent(EnderDragon.Phase.class, (String)configurationSection.getString("phase")).or((Object)EnderDragon.Phase.ROAR_BEFORE_ATTACK));
                            } else if (livingEntity instanceof Phantom) {
                                string22 = (Phantom)livingEntity;
                                string22.setSize(configurationSection.getInt("size"));
                            } else if (livingEntity instanceof Fox) {
                                string22 = (Fox)livingEntity;
                                string22.setCrouching(configurationSection.getBoolean("crouching"));
                                string22.setSleeping(configurationSection.getBoolean("sleeping"));
                                string22.setFoxType((Fox.Type)Enums.getIfPresent(Fox.Type.class, (String)configurationSection.getString("type")).or((Object)Fox.Type.RED));
                            } else if (XMaterial.supports(14)) {
                                if (livingEntity instanceof Panda) {
                                    string22 = (Panda)livingEntity;
                                    string22.setHiddenGene((Panda.Gene)Enums.getIfPresent(Panda.Gene.class, (String)configurationSection.getString("hidden-gene")).or((Object)Panda.Gene.PLAYFUL));
                                    string22.setMainGene((Panda.Gene)Enums.getIfPresent(Panda.Gene.class, (String)configurationSection.getString("main-gene")).or((Object)Panda.Gene.NORMAL));
                                } else if (livingEntity instanceof MushroomCow) {
                                    string22 = (MushroomCow)livingEntity;
                                    string22.setVariant((MushroomCow.Variant)Enums.getIfPresent(MushroomCow.Variant.class, (String)configurationSection.getString("variant")).or((Object)MushroomCow.Variant.RED));
                                } else if (XMaterial.supports(15)) {
                                    if (livingEntity instanceof Bee) {
                                        string22 = (Bee)livingEntity;
                                        string22.setAnger(configurationSection.getInt("anger") * 20);
                                        string22.setHasNectar(configurationSection.getBoolean("nectar"));
                                        string22.setHasStung(configurationSection.getBoolean("stung"));
                                        string22.setCannotEnterHiveTicks(configurationSection.getInt("disallow-hive") * 20);
                                    } else if (XMaterial.supports(16)) {
                                        if (livingEntity instanceof Hoglin) {
                                            string22 = (Hoglin)livingEntity;
                                            string22.setConversionTime(configurationSection.getInt("conversation") * 20);
                                            string22.setImmuneToZombification(configurationSection.getBoolean("zombification-immunity"));
                                            string22.setIsAbleToBeHunted(configurationSection.getBoolean("can-be-hunted"));
                                        } else if (livingEntity instanceof Piglin) {
                                            string22 = (Piglin)livingEntity;
                                            string22.setConversionTime(configurationSection.getInt("conversation") * 20);
                                            string22.setImmuneToZombification(configurationSection.getBoolean("zombification-immunity"));
                                        } else if (livingEntity instanceof Strider) {
                                            string22 = (Strider)livingEntity;
                                            string22.setShivering(configurationSection.getBoolean("shivering"));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (entity instanceof EnderSignal) {
            EnderSignal enderSignal = (EnderSignal)entity;
            enderSignal.setDespawnTimer(configurationSection.getInt("despawn-timer"));
            enderSignal.setDropItem(configurationSection.getBoolean("drop-item"));
        } else if (entity instanceof ExperienceOrb) {
            ExperienceOrb experienceOrb = (ExperienceOrb)entity;
            experienceOrb.setExperience(configurationSection.getInt("exp"));
        } else if (entity instanceof Explosive) {
            Explosive explosive = (Explosive)entity;
            explosive.setIsIncendiary(configurationSection.getBoolean("incendiary"));
        } else if (entity instanceof EnderCrystal) {
            EnderCrystal enderCrystal = (EnderCrystal)entity;
            enderCrystal.setShowingBottom(configurationSection.getBoolean("show-bottom"));
        }
        return entity;
    }

    static {
        EnumSet<EntityType[]> enumSet = EnumSet.of(EntityType.SKELETON_HORSE, new EntityType[]{EntityType.SKELETON, EntityType.ZOMBIE, EntityType.ZOMBIE_VILLAGER, EntityType.WITHER, EntityType.WITHER_SKELETON, EntityType.ZOMBIE_HORSE});
        if (XMaterial.supports(10)) {
            enumSet.add((EntityType[])EntityType.HUSK);
            enumSet.add((EntityType[])EntityType.STRAY);
            if (XMaterial.isNewVersion()) {
                enumSet.add((EntityType[])EntityType.DROWNED);
                enumSet.add((EntityType[])EntityType.PHANTOM);
                if (XMaterial.supports(16)) {
                    enumSet.add((EntityType[])EntityType.ZOGLIN);
                    enumSet.add((EntityType[])EntityType.PIGLIN);
                    enumSet.add((EntityType[])EntityType.ZOMBIFIED_PIGLIN);
                }
            }
        }
        if (!XMaterial.supports(16)) {
            enumSet.add((EntityType[])EntityType.valueOf((String)"PIG_ZOMBIE"));
        }
        UNDEAD = Collections.unmodifiableSet(enumSet);
    }
}

