/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.xseries;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.type.Cake;
import org.bukkit.block.data.type.EndPortalFrame;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.material.Colorable;
import org.bukkit.material.Directional;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Wood;
import org.bukkit.material.Wool;
import org.skills.utils.xseries.XMaterial;

public final class XBlock {
    public static final Set<XMaterial> CROPS = Collections.unmodifiableSet(EnumSet.of(XMaterial.CARROT, new XMaterial[]{XMaterial.POTATO, XMaterial.NETHER_WART, XMaterial.WHEAT_SEEDS, XMaterial.PUMPKIN_SEEDS, XMaterial.MELON_SEEDS, XMaterial.BEETROOT_SEEDS, XMaterial.SUGAR_CANE, XMaterial.BAMBOO_SAPLING, XMaterial.CHORUS_PLANT, XMaterial.KELP, XMaterial.SEA_PICKLE, XMaterial.BROWN_MUSHROOM, XMaterial.RED_MUSHROOM}));
    public static final Set<XMaterial> DANGEROUS = Collections.unmodifiableSet(EnumSet.of(XMaterial.MAGMA_BLOCK, XMaterial.LAVA, XMaterial.CAMPFIRE, XMaterial.FIRE, XMaterial.SOUL_FIRE));
    public static final byte CAKE_SLICES = 6;
    private static final boolean ISFLAT = XMaterial.isNewVersion();

    private XBlock() {
    }

    public static boolean isLit(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Lightable)) {
                return false;
            }
            Lightable lightable = (Lightable)block.getBlockData();
            return lightable.isLit();
        }
        return XBlock.isMaterial(block, BlockMaterial.REDSTONE_LAMP_ON, BlockMaterial.REDSTONE_TORCH_ON, BlockMaterial.BURNING_FURNACE);
    }

    public static boolean isContainer(@Nullable Block block) {
        return block != null && block.getState() instanceof InventoryHolder;
    }

    public static void setLit(Block block, boolean bl) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Lightable)) {
                return;
            }
            Lightable lightable = (Lightable)block.getBlockData();
            lightable.setLit(bl);
            return;
        }
        String string = block.getType().name();
        if (string.endsWith("FURNACE")) {
            block.setType(BlockMaterial.BURNING_FURNACE.material);
        } else if (string.startsWith("REDSTONE_LAMP")) {
            block.setType(BlockMaterial.REDSTONE_LAMP_ON.material);
        } else {
            block.setType(BlockMaterial.REDSTONE_TORCH_ON.material);
        }
    }

    public static boolean isCrop(XMaterial xMaterial) {
        return CROPS.contains((Object)xMaterial);
    }

    public static boolean isDangerous(XMaterial xMaterial) {
        return DANGEROUS.contains((Object)xMaterial);
    }

    public static DyeColor getColor(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Colorable)) {
                return null;
            }
            Colorable colorable = (Colorable)block.getBlockData();
            return colorable.getColor();
        }
        BlockState blockState = block.getState();
        MaterialData materialData = blockState.getData();
        if (materialData instanceof Wool) {
            Wool wool = (Wool)materialData;
            return wool.getColor();
        }
        return null;
    }

    public static boolean isCake(@Nullable Material material) {
        return material == Material.CAKE || material == BlockMaterial.CAKE_BLOCK.material;
    }

    public static boolean isWheat(@Nullable Material material) {
        return material == Material.WHEAT || material == BlockMaterial.CROPS.material;
    }

    public static boolean isSugarCane(@Nullable Material material) {
        return material == Material.SUGAR_CANE || material == BlockMaterial.SUGAR_CANE_BLOCK.material;
    }

    public static boolean isBeetroot(@Nullable Material material) {
        return material == Material.BEETROOT || material == Material.BEETROOTS || material == BlockMaterial.BEETROOT_BLOCK.material;
    }

    public static boolean isNetherWart(@Nullable Material material) {
        return material == Material.NETHER_WART || material == BlockMaterial.NETHER_WARTS.material;
    }

    public static boolean isCarrot(@Nullable Material material) {
        return material == Material.CARROT || material == Material.CARROTS;
    }

    public static boolean isMelon(@Nullable Material material) {
        return material == Material.MELON || material == Material.MELON_SLICE || material == BlockMaterial.MELON_BLOCK.material;
    }

    public static boolean isPotato(@Nullable Material material) {
        return material == Material.POTATO || material == Material.POTATOES;
    }

    public static BlockFace getDirection(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof org.bukkit.block.data.Directional)) {
                return BlockFace.SELF;
            }
            org.bukkit.block.data.Directional directional = (org.bukkit.block.data.Directional)block.getBlockData();
            return directional.getFacing();
        }
        BlockState blockState = block.getState();
        MaterialData materialData = blockState.getData();
        if (materialData instanceof Directional) {
            return ((Directional)materialData).getFacing();
        }
        return BlockFace.SELF;
    }

    public static boolean setDirection(Block block, BlockFace blockFace) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof org.bukkit.block.data.Directional)) {
                return false;
            }
            org.bukkit.block.data.Directional directional = (org.bukkit.block.data.Directional)block.getBlockData();
            directional.setFacing(blockFace);
            return true;
        }
        BlockState blockState = block.getState();
        MaterialData materialData = blockState.getData();
        if (materialData instanceof Directional) {
            ((Directional)materialData).setFacingDirection(blockFace);
            blockState.update(true);
            return true;
        }
        return false;
    }

    public static int getAge(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Ageable)) {
                return 0;
            }
            Ageable ageable = (Ageable)block.getBlockData();
            return ageable.getAge();
        }
        BlockState blockState = block.getState();
        MaterialData materialData = blockState.getData();
        return materialData.getData();
    }

    public static void setAge(Block block, int n) {
        BlockState blockState;
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Ageable)) {
                return;
            }
            blockState = (Ageable)block.getBlockData();
            blockState.setAge(n);
        }
        blockState = block.getState();
        MaterialData materialData = blockState.getData();
        materialData.setData((byte)n);
        blockState.update(true);
    }

    public static boolean setColor(Block block, DyeColor dyeColor) {
        if (ISFLAT) {
            String string = block.getType().name();
            int n = string.indexOf(95);
            if (n == -1) {
                return false;
            }
            String string2 = string.substring(n);
            Material material = Material.getMaterial((String)(dyeColor.name() + '_' + string2));
            if (material == null) {
                return false;
            }
            block.setType(material);
            return true;
        }
        BlockState blockState = block.getState();
        blockState.setRawData(dyeColor.getWoolData());
        blockState.update(true);
        return false;
    }

    public static boolean setFluidLevel(Block block, int n) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Levelled)) {
                return false;
            }
            Levelled levelled = (Levelled)block.getBlockData();
            levelled.setLevel(n);
            return true;
        }
        BlockState blockState = block.getState();
        MaterialData materialData = blockState.getData();
        materialData.setData((byte)n);
        blockState.update(true);
        return false;
    }

    public static int getFluidLevel(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Levelled)) {
                return -1;
            }
            Levelled levelled = (Levelled)block.getBlockData();
            return levelled.getLevel();
        }
        BlockState blockState = block.getState();
        MaterialData materialData = blockState.getData();
        return materialData.getData();
    }

    public static boolean isWaterStationary(Block block) {
        return ISFLAT ? XBlock.getFluidLevel(block) < 7 : block.getType() == BlockMaterial.STATIONARY_WATER.material;
    }

    public static boolean isWater(Material material) {
        return material == Material.WATER || material == BlockMaterial.STATIONARY_WATER.material;
    }

    public static boolean isLava(Material material) {
        return material == Material.LAVA || material == BlockMaterial.STATIONARY_LAVA.material;
    }

    public static boolean isOneOf(Block block, Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        String string = block.getType().name();
        XMaterial xMaterial = XMaterial.matchXMaterial(block.getType());
        for (String string2 : collection) {
            Optional<XMaterial> optional;
            String string3 = string2.toUpperCase(Locale.ENGLISH);
            if (!(string3.startsWith("CONTAINS:") ? string.contains(string2 = XMaterial.format(string3.substring(9))) : (string3.startsWith("REGEX:") ? string.matches(string2 = string2.substring(6)) : (optional = XMaterial.matchXMaterial(string2)).isPresent() && (xMaterial == optional.get() || XBlock.isType(block, optional.get()))))) continue;
            return true;
        }
        return false;
    }

    public static void setCakeSlices(Block block, int n) {
        Validate.isTrue((boolean)XBlock.isCake(block.getType()), (String)("Block is not a cake: " + block.getType()));
        if (ISFLAT) {
            BlockData blockData = block.getBlockData();
            Cake cake = (Cake)blockData;
            int n2 = cake.getMaximumBites() - (cake.getBites() + n);
            if (n2 > 0) {
                cake.setBites(n2);
                block.setBlockData(blockData);
            } else {
                block.breakNaturally();
            }
            return;
        }
        BlockState blockState = block.getState();
        org.bukkit.material.Cake cake = (org.bukkit.material.Cake)blockState.getData();
        if (n > 0) {
            cake.setSlicesRemaining(n);
            blockState.update(true);
        } else {
            block.breakNaturally();
        }
    }

    public static int addCakeSlices(Block block, int n) {
        Validate.isTrue((boolean)XBlock.isCake(block.getType()), (String)("Block is not a cake: " + block.getType()));
        if (ISFLAT) {
            BlockData blockData = block.getBlockData();
            Cake cake = (Cake)blockData;
            int n2 = cake.getBites() - n;
            int n3 = cake.getMaximumBites() - n2;
            if (n3 > 0) {
                cake.setBites(n2);
                block.setBlockData(blockData);
                return n3;
            }
            block.breakNaturally();
            return 0;
        }
        BlockState blockState = block.getState();
        org.bukkit.material.Cake cake = (org.bukkit.material.Cake)blockState.getData();
        int n4 = cake.getSlicesRemaining() + n;
        if (n4 > 0) {
            cake.setSlicesRemaining(n4);
            blockState.update(true);
            return n4;
        }
        block.breakNaturally();
        return 0;
    }

    public static boolean setWooden(Block block, XMaterial xMaterial) {
        block.setType(xMaterial.parseMaterial());
        if (ISFLAT) {
            return true;
        }
        TreeSpecies treeSpecies = xMaterial == XMaterial.SPRUCE_LOG ? TreeSpecies.REDWOOD : TreeSpecies.valueOf((String)xMaterial.name().substring(0, xMaterial.name().indexOf(95)));
        BlockState blockState = block.getState();
        MaterialData materialData = blockState.getData();
        ((Wood)materialData).setSpecies(treeSpecies);
        blockState.update(true);
        return true;
    }

    public static void setEnderPearlOnFrame(Block block, boolean bl) {
        BlockState blockState = block.getState();
        if (ISFLAT) {
            BlockData blockData = blockState.getBlockData();
            EndPortalFrame endPortalFrame = (EndPortalFrame)blockData;
            endPortalFrame.setEye(bl);
            blockState.setBlockData(blockData);
        } else {
            blockState.setRawData((byte)(bl ? 4 : 0));
        }
        blockState.update(true);
    }

    @Deprecated
    public static XMaterial getType(Block block) {
        if (ISFLAT) {
            return XMaterial.matchXMaterial(block.getType());
        }
        String string = block.getType().name();
        BlockState blockState = block.getState();
        MaterialData materialData = blockState.getData();
        if (materialData instanceof Wood) {
            TreeSpecies treeSpecies = ((Wood)materialData).getSpecies();
            return XMaterial.matchXMaterial(treeSpecies.name() + block.getType().name()).orElseThrow(() -> new IllegalArgumentException("Unsupported material from tree species " + treeSpecies.name() + ": " + block.getType().name()));
        }
        if (materialData instanceof Colorable) {
            Colorable colorable = (Colorable)materialData;
            return XMaterial.matchXMaterial(colorable.getColor().name() + '_' + string).orElseThrow(() -> new IllegalArgumentException("Unsupported colored material"));
        }
        return XMaterial.matchXMaterial(block.getType());
    }

    public static boolean isSimilar(Block block, XMaterial xMaterial) {
        return xMaterial == XMaterial.matchXMaterial(block.getType()) || XBlock.isType(block, xMaterial);
    }

    public static boolean isType(Block block, XMaterial xMaterial) {
        Material material = block.getType();
        switch (xMaterial) {
            case CAKE: {
                return XBlock.isCake(material);
            }
            case NETHER_WART: {
                return XBlock.isNetherWart(material);
            }
            case MELON: 
            case MELON_SLICE: {
                return XBlock.isMelon(material);
            }
            case CARROT: 
            case CARROTS: {
                return XBlock.isCarrot(material);
            }
            case POTATO: 
            case POTATOES: {
                return XBlock.isPotato(material);
            }
            case WHEAT: 
            case WHEAT_SEEDS: {
                return XBlock.isWheat(material);
            }
            case BEETROOT: 
            case BEETROOT_SEEDS: 
            case BEETROOTS: {
                return XBlock.isBeetroot(material);
            }
            case SUGAR_CANE: {
                return XBlock.isSugarCane(material);
            }
            case WATER: {
                return XBlock.isWater(material);
            }
            case LAVA: {
                return XBlock.isLava(material);
            }
            case AIR: 
            case CAVE_AIR: 
            case VOID_AIR: {
                return XBlock.isAir(material);
            }
        }
        return false;
    }

    public static boolean isAir(@Nullable Material material) {
        if (material == Material.AIR) {
            return true;
        }
        return ISFLAT && (material == Material.CAVE_AIR || material == Material.VOID_AIR);
    }

    public static boolean isPowered(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Powerable)) {
                return false;
            }
            Powerable powerable = (Powerable)block.getBlockData();
            return powerable.isPowered();
        }
        String string = block.getType().name();
        if (string.startsWith("REDSTONE_COMPARATOR")) {
            return block.getType() == BlockMaterial.REDSTONE_COMPARATOR_ON.material;
        }
        return false;
    }

    public static void setPowered(Block block, boolean bl) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Powerable)) {
                return;
            }
            Powerable powerable = (Powerable)block.getBlockData();
            powerable.setPowered(bl);
            return;
        }
        String string = block.getType().name();
        if (string.startsWith("REDSTONE_COMPARATOR")) {
            block.setType(BlockMaterial.REDSTONE_COMPARATOR_ON.material);
        }
    }

    public static boolean isOpen(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Openable)) {
                return false;
            }
            Openable openable = (Openable)block.getBlockData();
            return openable.isOpen();
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof org.bukkit.material.Openable)) {
            return false;
        }
        org.bukkit.material.Openable openable = (org.bukkit.material.Openable)blockState.getData();
        return openable.isOpen();
    }

    public static void setOpened(Block block, boolean bl) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Openable)) {
                return;
            }
            Openable openable = (Openable)block.getBlockData();
            openable.setOpen(bl);
            return;
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof org.bukkit.material.Openable)) {
            return;
        }
        org.bukkit.material.Openable openable = (org.bukkit.material.Openable)blockState.getData();
        openable.setOpen(bl);
        blockState.setData((MaterialData)openable);
        blockState.update();
    }

    public static BlockFace getRotation(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Rotatable)) {
                return null;
            }
            Rotatable rotatable = (Rotatable)block.getBlockData();
            return rotatable.getRotation();
        }
        return null;
    }

    public static void setRotation(Block block, BlockFace blockFace) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Rotatable)) {
                return;
            }
            Rotatable rotatable = (Rotatable)block.getBlockData();
            rotatable.setRotation(blockFace);
        }
    }

    private static boolean isMaterial(Block block, BlockMaterial ... blockMaterialArray) {
        Material material = block.getType();
        for (BlockMaterial blockMaterial : blockMaterialArray) {
            if (material != blockMaterial.material) continue;
            return true;
        }
        return false;
    }

    public static enum BlockMaterial {
        CAKE_BLOCK,
        CROPS,
        SUGAR_CANE_BLOCK,
        BEETROOT_BLOCK,
        NETHER_WARTS,
        MELON_BLOCK,
        BURNING_FURNACE,
        STATIONARY_WATER,
        STATIONARY_LAVA,
        REDSTONE_LAMP_ON,
        REDSTONE_LAMP_OFF,
        REDSTONE_TORCH_ON,
        REDSTONE_TORCH_OFF,
        REDSTONE_COMPARATOR_ON,
        REDSTONE_COMPARATOR_OFF;

        @Nullable
        private final Material material = Material.getMaterial((String)this.name());
    }
}

