/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.xseries;

import com.google.common.base.Enums;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.skills.utils.xseries.XMaterial;

public enum XBiome {
    BADLANDS(World.Environment.NORMAL, "MESA"),
    BADLANDS_PLATEAU(World.Environment.NORMAL, "MESA_CLEAR_ROCK", "MESA_PLATEAU"),
    BEACH(World.Environment.NORMAL, "BEACHES"),
    BIRCH_FOREST(World.Environment.NORMAL, "BIRCH_FOREST"),
    BIRCH_FOREST_HILLS(World.Environment.NORMAL, "BIRCH_FOREST_HILLS"),
    COLD_OCEAN(World.Environment.NORMAL, "COLD_OCEAN"),
    DARK_FOREST(World.Environment.NORMAL, "ROOFED_FOREST"),
    DARK_FOREST_HILLS(World.Environment.NORMAL, "MUTATED_ROOFED_FOREST", "ROOFED_FOREST_MOUNTAINS"),
    DEEP_COLD_OCEAN(World.Environment.NORMAL, "COLD_DEEP_OCEAN"),
    DEEP_FROZEN_OCEAN(World.Environment.NORMAL, "FROZEN_DEEP_OCEAN"),
    DEEP_LUKEWARM_OCEAN(World.Environment.NORMAL, "LUKEWARM_DEEP_OCEAN"),
    DEEP_OCEAN(World.Environment.NORMAL, "DEEP_OCEAN"),
    DEEP_WARM_OCEAN(World.Environment.NORMAL, "WARM_DEEP_OCEAN"),
    DESERT(World.Environment.NORMAL, "DESERT"),
    DESERT_HILLS(World.Environment.NORMAL, "DESERT_HILLS"),
    DESERT_LAKES(World.Environment.NORMAL, "MUTATED_DESERT", "DESERT_MOUNTAINS"),
    END_BARRENS(World.Environment.THE_END, "SKY_ISLAND_BARREN"),
    END_HIGHLANDS(World.Environment.THE_END, "SKY_ISLAND_HIGH"),
    END_MIDLANDS(World.Environment.THE_END, "SKY_ISLAND_MEDIUM"),
    ERODED_BADLANDS(World.Environment.NORMAL, "MUTATED_MESA", "MESA_BRYCE"),
    FLOWER_FOREST(World.Environment.NORMAL, "MUTATED_FOREST"),
    FOREST(World.Environment.NORMAL, "FOREST"),
    FROZEN_OCEAN(World.Environment.NORMAL, "FROZEN_OCEAN"),
    FROZEN_RIVER(World.Environment.NORMAL, "FROZEN_RIVER"),
    GIANT_SPRUCE_TAIGA(World.Environment.NORMAL, "MUTATED_REDWOOD_TAIGA", "MEGA_SPRUCE_TAIGA"),
    GIANT_SPRUCE_TAIGA_HILLS(World.Environment.NORMAL, "MUTATED_REDWOOD_TAIGA_HILLS", "MEGA_SPRUCE_TAIGA_HILLS"),
    GIANT_TREE_TAIGA(World.Environment.NORMAL, "REDWOOD_TAIGA", "MEGA_TAIGA"),
    GIANT_TREE_TAIGA_HILLS(World.Environment.NORMAL, "REDWOOD_TAIGA_HILLS", "MEGA_TAIGA_HILLS"),
    GRAVELLY_MOUNTAINS(World.Environment.NORMAL, "MUTATED_EXTREME_HILLS", "EXTREME_HILLS_MOUNTAINS"),
    ICE_SPIKES(World.Environment.NORMAL, "MUTATED_ICE_FLATS", "ICE_PLAINS_SPIKES"),
    JUNGLE(World.Environment.NORMAL, "JUNGLE"),
    JUNGLE_EDGE(World.Environment.NORMAL, "JUNGLE_EDGE"),
    JUNGLE_HILLS(World.Environment.NORMAL, "JUNGLE_HILLS"),
    LUKEWARM_OCEAN(World.Environment.NORMAL, "LUKEWARM_OCEAN"),
    MODIFIED_BADLANDS_PLATEAU(World.Environment.NORMAL, "MUTATED_MESA_CLEAR_ROCK", "MESA_PLATEAU"),
    MODIFIED_GRAVELLY_MOUNTAINS(World.Environment.NORMAL, "MUTATED_EXTREME_HILLS_WITH_TREES", "EXTREME_HILLS_MOUNTAINS"),
    MODIFIED_JUNGLE(World.Environment.NORMAL, "MUTATED_JUNGLE", "JUNGLE_MOUNTAINS"),
    MODIFIED_JUNGLE_EDGE(World.Environment.NORMAL, "MUTATED_JUNGLE_EDGE", "JUNGLE_EDGE_MOUNTAINS"),
    MODIFIED_WOODED_BADLANDS_PLATEAU(World.Environment.NORMAL, "MUTATED_MESA_ROCK", "MESA_PLATEAU_FOREST_MOUNTAINS"),
    MOUNTAINS(World.Environment.NORMAL, "EXTREME_HILLS"),
    MOUNTAIN_EDGE(World.Environment.NORMAL, "SMALLER_EXTREME_HILLS"),
    MUSHROOM_FIELDS(World.Environment.NORMAL, "MUSHROOM_ISLAND"),
    MUSHROOM_FIELD_SHORE(World.Environment.NORMAL, "MUSHROOM_ISLAND_SHORE", "MUSHROOM_SHORE"),
    SOUL_SAND_VALLEY(World.Environment.NETHER, new String[0]),
    CRIMSON_FOREST(World.Environment.NETHER, new String[0]),
    WARPED_FOREST(World.Environment.NETHER, new String[0]),
    BASALT_DELTAS(World.Environment.NETHER, new String[0]),
    NETHER_WASTES(World.Environment.NETHER, "NETHER", "HELL"),
    OCEAN(World.Environment.NORMAL, "OCEAN"),
    PLAINS(World.Environment.NORMAL, "PLAINS"),
    RIVER(World.Environment.NORMAL, "RIVER"),
    SAVANNA(World.Environment.NORMAL, "SAVANNA"),
    SAVANNA_PLATEAU(World.Environment.NORMAL, "SAVANNA_ROCK", "SAVANNA_PLATEAU"),
    SHATTERED_SAVANNA(World.Environment.NORMAL, "MUTATED_SAVANNA", "SAVANNA_MOUNTAINS"),
    SHATTERED_SAVANNA_PLATEAU(World.Environment.NORMAL, "MUTATED_SAVANNA_ROCK", "SAVANNA_PLATEAU_MOUNTAINS"),
    SMALL_END_ISLANDS(World.Environment.THE_END, "SKY_ISLAND_LOW"),
    SNOWY_BEACH(World.Environment.NORMAL, "COLD_BEACH"),
    SNOWY_MOUNTAINS(World.Environment.NORMAL, "ICE_MOUNTAINS"),
    SNOWY_TAIGA(World.Environment.NORMAL, "TAIGA_COLD", "COLD_TAIGA"),
    SNOWY_TAIGA_HILLS(World.Environment.NORMAL, "TAIGA_COLD_HILLS", "COLD_TAIGA_HILLS"),
    SNOWY_TAIGA_MOUNTAINS(World.Environment.NORMAL, "MUTATED_TAIGA_COLD", "COLD_TAIGA_MOUNTAINS"),
    SNOWY_TUNDRA(World.Environment.NORMAL, "ICE_FLATS", "ICE_PLAINS"),
    STONE_SHORE(World.Environment.NORMAL, "STONE_BEACH"),
    SUNFLOWER_PLAINS(World.Environment.NORMAL, "MUTATED_PLAINS"),
    SWAMP(World.Environment.NORMAL, "SWAMPLAND"),
    SWAMP_HILLS(World.Environment.NORMAL, "MUTATED_SWAMPLAND", "SWAMPLAND_MOUNTAINS"),
    TAIGA(World.Environment.NORMAL, "TAIGA"),
    TAIGA_HILLS(World.Environment.NORMAL, "TAIGA_HILLS"),
    TAIGA_MOUNTAINS(World.Environment.NORMAL, "MUTATED_TAIGA"),
    TALL_BIRCH_FOREST(World.Environment.NORMAL, "MUTATED_BIRCH_FOREST", "BIRCH_FOREST_MOUNTAINS"),
    TALL_BIRCH_HILLS(World.Environment.NORMAL, "MUTATED_BIRCH_FOREST_HILLS", "MESA_PLATEAU_FOREST_MOUNTAINS"),
    THE_END(World.Environment.THE_END, "SKY"),
    THE_VOID(World.Environment.NORMAL, "VOID"),
    WARM_OCEAN(World.Environment.NORMAL, "WARM_OCEAN"),
    WOODED_BADLANDS_PLATEAU(World.Environment.NORMAL, "MESA_ROCK", "MESA_PLATEAU_FOREST"),
    WOODED_HILLS(World.Environment.NORMAL, "FOREST_HILLS"),
    WOODED_MOUNTAINS(World.Environment.NORMAL, "EXTREME_HILLS_WITH_TREES", "EXTREME_HILLS_PLUS"),
    BAMBOO_JUNGLE(World.Environment.NORMAL, new String[0]),
    BAMBOO_JUNGLE_HILLS(World.Environment.NORMAL, new String[0]);

    public static final List<XBiome> VALUES;
    private static final boolean HORIZONTAL_SUPPORT;
    @Nullable
    private final Biome biome;
    @Nonnull
    private final World.Environment environment;

    private XBiome(World.Environment environment, String ... biome) {
        this.environment = environment;
        Data.NAMES.put(this.name(), this);
        for (String string2 : biome) {
            Data.NAMES.put(string2, this);
        }
        Biome biome2 = (Biome)Enums.getIfPresent(Biome.class, (String)this.name()).orNull();
        if (biome2 == null) {
            Biome biome3;
            Biome biome4 = biome;
            int n2 = ((Biome)biome4).length;
            for (int i = 0; i < n2 && (biome2 = (Biome)Enums.getIfPresent(Biome.class, (String)(biome3 = biome4[i])).orNull()) == null; ++i) {
            }
        }
        this.biome = biome2;
    }

    @Nonnull
    private static String format(@Nonnull String string) {
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!(bl || n2 == 0 || c != '-' && c != ' ' && c != '_' || cArray[n2] == '_')) {
                bl = true;
                continue;
            }
            if ((c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) continue;
            if (bl) {
                cArray[n2++] = 95;
                bl = false;
            }
            cArray[n2++] = (char)(c & 0x5F);
        }
        return new String(cArray, 0, n2);
    }

    @Nonnull
    public static Optional<XBiome> matchXBiome(@Nonnull String string) {
        Validate.notEmpty((String)string, (String)"Cannot match XBiome of a null or empty biome name");
        return Optional.ofNullable((XBiome)((Object)Data.NAMES.get(XBiome.format(string))));
    }

    @Nonnull
    public static XBiome matchXBiome(@Nonnull Biome biome) {
        Objects.requireNonNull(biome, "Cannot match XBiome of a null biome");
        return Objects.requireNonNull((XBiome)((Object)Data.NAMES.get(biome.name())), () -> "Unsupported biome: " + biome.name());
    }

    @Nonnull
    public World.Environment getEnvironment() {
        return this.environment;
    }

    @Nullable
    public Biome getBiome() {
        return this.biome;
    }

    @Nonnull
    public CompletableFuture<Void> setBiome(@Nonnull Chunk chunk) {
        Objects.requireNonNull(this.biome, () -> "Unsupported biome: " + this.name());
        Objects.requireNonNull(chunk, "Cannot set biome of null chunk");
        if (!chunk.isLoaded()) {
            Validate.isTrue((boolean)chunk.load(true), (String)("Could not load chunk at " + chunk.getX() + ", " + chunk.getZ()));
        }
        return CompletableFuture.runAsync(() -> {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < (HORIZONTAL_SUPPORT ? 256 : 1); j += 4) {
                    for (int k = 0; k < 16; ++k) {
                        Block block = chunk.getBlock(i, j, k);
                        if (block.getBiome() == this.biome) continue;
                        block.setBiome(this.biome);
                    }
                }
            }
        }).exceptionally(throwable -> {
            throwable.printStackTrace();
            return null;
        });
    }

    @Nonnull
    public CompletableFuture<Void> setBiome(@Nonnull Location location, @Nonnull Location location2) {
        Objects.requireNonNull(location, "Start location cannot be null");
        Objects.requireNonNull(location2, "End location cannot be null");
        Objects.requireNonNull(this.biome, () -> "Unsupported biome: " + this.name());
        Validate.isTrue((boolean)location.getWorld().getUID().equals(location2.getWorld().getUID()), (String)"Location worlds mismatch");
        return CompletableFuture.runAsync(() -> {
            for (int i = location.getBlockX(); i < location2.getBlockX(); ++i) {
                for (int j = 0; j < (HORIZONTAL_SUPPORT ? 256 : 1); j += 4) {
                    for (int k = location.getBlockZ(); k < location2.getBlockZ(); ++k) {
                        Block block = new Location(location.getWorld(), (double)i, (double)j, (double)k).getBlock();
                        if (block.getBiome() == this.biome) continue;
                        block.setBiome(this.biome);
                    }
                }
            }
        }).exceptionally(throwable -> {
            throwable.printStackTrace();
            return null;
        });
    }

    static {
        VALUES = Collections.unmodifiableList(Arrays.asList(XBiome.values()));
        HORIZONTAL_SUPPORT = XMaterial.supports(16);
    }

    private static final class Data {
        private static final Map<String, XBiome> NAMES = new HashMap<String, XBiome>();

        private Data() {
        }
    }
}

