/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.xseries;

import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.skills.utils.xseries.ReflectionUtils;
import org.skills.utils.xseries.SkullCacheListener;
import org.skills.utils.xseries.XMaterial;

public class SkullUtils {
    protected static final MethodHandle GAME_PROFILE;
    private static final String VALUE_PROPERTY = "{\"textures\":{\"SKIN\":{\"url\":\"";
    private static final boolean SUPPORTS_UUID;
    private static final String TEXTURES = "https://textures.minecraft.net/texture/";

    @Nonnull
    public static ItemStack getSkull(@Nonnull UUID uUID) {
        ItemStack itemStack = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        if (SUPPORTS_UUID) {
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)uUID));
        } else {
            skullMeta.setOwner(uUID.toString());
        }
        itemStack.setItemMeta((ItemMeta)skullMeta);
        return itemStack;
    }

    @Nonnull
    public static SkullMeta applyCachedSkin(@Nonnull ItemMeta itemMeta, @Nonnull UUID uUID) {
        String string = (String)SkullCacheListener.CACHE.get(uUID);
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        return SkullUtils.getSkullByValue(skullMeta, string);
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta itemMeta, @Nonnull OfflinePlayer offlinePlayer) {
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        if (SUPPORTS_UUID) {
            skullMeta.setOwningPlayer(offlinePlayer);
        } else {
            skullMeta.setOwner(offlinePlayer.getName());
        }
        return skullMeta;
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta itemMeta, @Nonnull UUID uUID) {
        return SkullUtils.applySkin(itemMeta, Bukkit.getOfflinePlayer((UUID)uUID));
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta itemMeta, @Nonnull String string) {
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        if (SkullUtils.isUsername(string)) {
            return SkullUtils.applySkin(itemMeta, Bukkit.getOfflinePlayer((String)string));
        }
        if (string.contains("textures.minecraft.net")) {
            return SkullUtils.getValueFromTextures(skullMeta, string);
        }
        if (string.length() > 100 && SkullUtils.isBase64(string)) {
            return SkullUtils.getSkullByValue(skullMeta, string);
        }
        return SkullUtils.getTexturesFromUrlValue(skullMeta, string);
    }

    @Nonnull
    private static SkullMeta getSkullByValue(@Nonnull SkullMeta skullMeta, @Nonnull String string) {
        Validate.notEmpty((String)string, (String)"Skull value cannot be null or empty");
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), null);
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", string));
        try {
            GAME_PROFILE.invoke(skullMeta, gameProfile);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return skullMeta;
    }

    @Nonnull
    private static SkullMeta getValueFromTextures(@Nonnull SkullMeta skullMeta, @Nonnull String string) {
        return SkullUtils.getSkullByValue(skullMeta, SkullUtils.encodeBase64(VALUE_PROPERTY + string + "\"}}}"));
    }

    @Nonnull
    private static SkullMeta getTexturesFromUrlValue(@Nonnull SkullMeta skullMeta, @Nonnull String string) {
        return SkullUtils.getValueFromTextures(skullMeta, TEXTURES + string);
    }

    @Nonnull
    private static String encodeBase64(@Nonnull String string) {
        return Base64.getEncoder().encodeToString(string.getBytes());
    }

    private static boolean isBase64(@Nonnull String string) {
        try {
            Base64.getDecoder().decode(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Nullable
    public static String getSkinValue(@Nonnull ItemMeta itemMeta) {
        Objects.requireNonNull(itemMeta, "Skull ItemStack cannot be null");
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        GameProfile gameProfile = null;
        try {
            Field field = skullMeta.getClass().getDeclaredField("profile");
            field.setAccessible(true);
            gameProfile = (GameProfile)field.get(skullMeta);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
            exception.printStackTrace();
        }
        if (gameProfile != null && !gameProfile.getProperties().get((Object)"textures").isEmpty()) {
            for (Property property : gameProfile.getProperties().get((Object)"textures")) {
                if (property.getValue().isEmpty()) continue;
                return property.getValue();
            }
        }
        return null;
    }

    private static boolean isUsername(@Nonnull String string) {
        int n = string.length();
        if (n < 3 || n > 16) {
            return false;
        }
        UnmodifiableIterator unmodifiableIterator = Lists.charactersOf((String)string).iterator();
        while (unmodifiableIterator.hasNext()) {
            char c = ((Character)unmodifiableIterator.next()).charValue();
            if (c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    static {
        SUPPORTS_UUID = XMaterial.supports(12);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle methodHandle = null;
        try {
            Class<?> clazz = ReflectionUtils.getCraftClass("inventory.CraftMetaSkull");
            Field field = clazz.getDeclaredField("profile");
            field.setAccessible(true);
            methodHandle = lookup.unreflectSetter(field);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
        GAME_PROFILE = methodHandle;
    }
}

