/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.xseries;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ReflectionUtils {
    public static final String VERSION = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
    public static final String CRAFTBUKKIT = "org.bukkit.craftbukkit." + VERSION + '.';
    public static final String NMS = "net.minecraft.server." + VERSION + '.';
    private static final MethodHandle PLAYER_CONNECTION;
    private static final MethodHandle GET_HANDLE;
    private static final MethodHandle SEND_PACKET;

    private ReflectionUtils() {
    }

    @Nullable
    public static Class<?> getNMSClass(@Nonnull String string) {
        try {
            return Class.forName(NMS + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    @Nonnull
    public static CompletableFuture<Void> sendPacket(@Nonnull Player player, Object ... objectArray) {
        return CompletableFuture.runAsync(() -> {
            try {
                Object object = GET_HANDLE.invoke(player);
                Object object2 = PLAYER_CONNECTION.invoke(object);
                if (object2 != null) {
                    for (Object object3 : objectArray) {
                        SEND_PACKET.invoke(object2, object3);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }).exceptionally(throwable -> {
            throwable.printStackTrace();
            return null;
        });
    }

    @Nullable
    public static Class<?> getCraftClass(@Nonnull String string) {
        try {
            return Class.forName(CRAFTBUKKIT + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    static {
        Class<?> clazz = ReflectionUtils.getNMSClass("EntityPlayer");
        Class<?> clazz2 = ReflectionUtils.getCraftClass("entity.CraftPlayer");
        Class<?> clazz3 = ReflectionUtils.getNMSClass("PlayerConnection");
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle methodHandle = null;
        MethodHandle methodHandle2 = null;
        MethodHandle methodHandle3 = null;
        try {
            methodHandle3 = lookup.findGetter(clazz, "playerConnection", clazz3);
            methodHandle2 = lookup.findVirtual(clazz2, "getHandle", MethodType.methodType(clazz));
            methodHandle = lookup.findVirtual(clazz3, "sendPacket", MethodType.methodType(Void.TYPE, ReflectionUtils.getNMSClass("Packet")));
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
        PLAYER_CONNECTION = methodHandle3;
        SEND_PACKET = methodHandle;
        GET_HANDLE = methodHandle2;
    }
}

